/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.serialize.json.impl;

import com.nlf.exception.NlfException;
import com.nlf.serialize.AbstractParser;
import com.nlf.serialize.json.exception.JsonFormatException;
import com.nlf.serialize.node.AbstractNode;
import com.nlf.serialize.node.INode;
import com.nlf.serialize.node.impl.NodeBool;
import com.nlf.serialize.node.impl.NodeList;
import com.nlf.serialize.node.impl.NodeMap;
import com.nlf.serialize.node.impl.NodeNumber;
import com.nlf.serialize.node.impl.NodeString;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;

public class DefaultJsonParser
extends AbstractParser {
    public static final int RIGHT_SLASH = 92;
    private int c;
    private int pos = 0;
    private String os;
    private Reader reader;

    public boolean support(String format) {
        return "json".equalsIgnoreCase(format);
    }

    public INode parseAll(String s) {
        this.os = s;
        if (null == s) {
            return null;
        }
        s = s.trim();
        this.reader = new StringReader(s);
        return this.parseNode();
    }

    private INode parseNode() {
        this.skip();
        switch (this.c) {
            case -1: {
                return null;
            }
            case 123: {
                return this.parseMap();
            }
            case 39: {
                return this.parseString();
            }
            case 34: {
                return this.parseString();
            }
            case 91: {
                return this.parseList();
            }
        }
        return this.parseElse();
    }

    private NodeString parseString() {
        NodeString o = null;
        if (39 == this.c) {
            this.next();
            o = new NodeString(this.readIgnoreSlash(39));
        } else if (34 == this.c) {
            this.next();
            o = new NodeString(this.readIgnoreSlash(34));
        }
        this.next();
        return o;
    }

    private INode parseElse() {
        AbstractNode o = null;
        String s = this.readUntil(new int[]{32, 44, 125, 93});
        if ("null".equals(s = s.trim())) {
            o = null;
        } else if ("true".equals(s)) {
            o = new NodeBool(true);
        } else if ("false".equals(s)) {
            o = new NodeBool(false);
        } else if (s.endsWith("f") || s.endsWith("F")) {
            o = new NodeNumber(new Float(s));
        } else if (s.endsWith("d") || s.endsWith("D")) {
            o = new NodeNumber(new Double(s));
        } else if (s.endsWith("l") || s.endsWith("L")) {
            o = new NodeNumber(Long.parseLong(s.substring(0, s.length() - 1)));
        } else {
            try {
                o = new NodeNumber(new BigDecimal(s));
            }
            catch (NumberFormatException e) {
                o = new NodeString(this.os);
            }
        }
        return o;
    }

    private String readIgnoreSlash(int endTag) {
        StringBuilder s = new StringBuilder();
        ArrayList<Integer> slash = new ArrayList<Integer>();
        while (-1 != this.c) {
            if (this.c == 92) {
                slash.add(this.c);
            } else {
                if (endTag == this.c && slash.size() % 2 == 0) break;
                slash.clear();
            }
            s.append((char)this.c);
            this.next();
        }
        return s.toString().replace("\\\\", "\\");
    }

    private String readUntil(int endTag) {
        return this.readUntil(new int[]{endTag});
    }

    private String readUntil(int[] endTags) {
        StringBuilder s = new StringBuilder();
        block0: while (-1 != this.c) {
            for (int t : endTags) {
                if (t == this.c) break block0;
            }
            s.append((char)this.c);
            this.next();
        }
        return s.toString();
    }

    private void parseMapItem(NodeMap o) {
        String key = "";
        this.skip();
        if (125 == this.c) {
            return;
        }
        if (39 == this.c) {
            this.next();
            key = this.readIgnoreSlash(39);
            this.next();
            this.skip();
            if (58 != this.c) {
                throw new JsonFormatException(this.os);
            }
            this.next();
        } else if (34 == this.c) {
            this.next();
            key = this.readIgnoreSlash(34);
            this.next();
            this.skip();
            if (58 != this.c) {
                throw new JsonFormatException(this.os);
            }
            this.next();
        } else {
            key = this.readUntil(58);
            key = key.trim();
            this.next();
        }
        INode el = this.parseNode();
        o.set(key, el);
    }

    private NodeMap parseMap() {
        NodeMap o = new NodeMap();
        this.next();
        this.parseMapItem(o);
        this.skip();
        while (44 == this.c) {
            this.next();
            this.parseMapItem(o);
            this.skip();
        }
        if (125 != this.c) {
            throw new JsonFormatException(this.os);
        }
        this.next();
        return o;
    }

    private void parseListItem(NodeList l) {
        this.skip();
        l.add(this.parseNode());
    }

    private NodeList parseList() {
        NodeList l = new NodeList();
        this.next();
        this.skip();
        if (93 == this.c) {
            this.next();
            return l;
        }
        this.parseListItem(l);
        this.skip();
        while (44 == this.c) {
            this.next();
            this.parseListItem(l);
            this.skip();
        }
        this.next();
        return l;
    }

    private void next() {
        try {
            this.c = this.reader.read();
            ++this.pos;
        }
        catch (IOException e) {
            throw new NlfException(e);
        }
    }

    private void skip() {
        if (-1 == this.c) {
            return;
        }
        if (0 <= this.c && 32 >= this.c) {
            this.next();
            this.skip();
        }
        if (127 == this.c || 13 == this.c || 10 == this.c) {
            this.next();
            this.skip();
        }
        if (47 == this.c) {
            this.next();
            if (-1 == this.c) {
                return;
            }
            if (47 == this.c) {
                do {
                    this.next();
                } while (13 != this.c && 10 != this.c && -1 != this.c);
                this.skip();
            } else if (42 == this.c) {
                while (-1 != this.c) {
                    this.next();
                    if (42 != this.c) continue;
                    this.next();
                    if (47 != this.c) continue;
                }
                this.skip();
            }
        }
    }
}

