/*
 * Decompiled with CFR 0.152.
 */
package com.nlf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, Object> values = new HashMap<String, Object>();

    public Bean() {
    }

    public Bean(String key, Object value) {
        this.values.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public <T> T get(String key) {
        return (T)this.values.get(key);
    }

    public <E> E get(String key, Class<E> klass) {
        return (E)this.values.get(key);
    }

    public <E> E get(String key, Class<E> klass, E defaultValue) {
        Object o = this.values.get(key);
        return (E)(null == o ? defaultValue : o);
    }

    public Bean set(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public Bean setIf(String key, Object value, boolean condition) {
        if (condition) {
            this.values.put(key, value);
        }
        return this;
    }

    public Bean remove(String key) {
        this.values.remove(key);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    public String toString() {
        return this.values.toString();
    }

    public Bean getBean(String key) {
        return (Bean)this.get(key);
    }

    public Bean getBean(String key, Bean defaultValue) {
        Bean v = null;
        try {
            v = (Bean)this.get(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null == v ? defaultValue : v;
    }

    public short getInt(String key, short defaultValue) {
        try {
            return Short.parseShort(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        try {
            return Long.parseLong(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        Object o = this.values.get(key);
        return null == o ? defaultValue : o.toString();
    }

    public <T> List<T> getList(String key) {
        ArrayList<Object> l = new ArrayList<Object>();
        Object o = this.values.get(key);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    public <E> List<E> getList(String key, Class<E> klass) {
        ArrayList<Object> l = new ArrayList<Object>();
        Object o = this.values.get(key);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        return this.containsKey(key + "");
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        return this.values.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    @Deprecated
    public Object put(String key, Object value) {
        return this.values.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.values.putAll(map);
    }

    @Override
    @Deprecated
    public Object remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    @Override
    public void clear() {
        this.values.clear();
    }
}

