/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.core;

import com.nlf.App;
import com.nlf.bytecode.Method;
import com.nlf.core.ClassMethod;
import com.nlf.core.IDispatcher;
import com.nlf.core.IFilterChain;
import com.nlf.core.IRequest;
import com.nlf.core.IResponse;
import com.nlf.core.RequestMapping;
import com.nlf.dao.connection.IConnection;
import com.nlf.log.Logger;
import com.nlf.resource.klass.ClassResource;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Map;

public abstract class AbstractDispatcher
implements IDispatcher {
    protected static final RequestMapping requestMapping = new RequestMapping();

    public void init() {
        for (ClassResource r : App.CLASS.values()) {
            String klass = r.getClassName();
            if (klass.startsWith(App.PACKAGE)) continue;
            for (Method m : r.getMethods()) {
                String ret = m.getRet();
                if ("V".equals(ret) || m.getArgs().size() > 0 || !Modifier.isPublic(m.getAccess()) || Modifier.isStatic(m.getAccess())) continue;
                if ("Ljava/lang/Object".equals(ret)) {
                    ret = m.getRetMaybe();
                }
                String method = m.getName();
                ClassMethod cm = new ClassMethod();
                cm.setKlass(klass);
                cm.setMethod(method);
                cm.setRet(ret);
                requestMapping.add("/" + klass + "/" + method, cm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(IRequest request, IResponse response, IFilterChain filterChain) throws IOException {
        ClassMethod cm = requestMapping.get(request.getPath());
        if (null == cm) {
            filterChain.doFilter(request, response);
            return;
        }
        Object r = null;
        try {
            this.before(cm);
            r = this.around(cm);
            r = this.after(cm, r);
        }
        catch (Throwable e) {
            r = this.afterThrowing(cm, e);
        }
        finally {
            this.afterReturning(cm);
        }
        response.send(r);
    }

    protected void before(ClassMethod cm) {
    }

    protected Object after(ClassMethod cm, Object ret) {
        return ret;
    }

    protected Object around(ClassMethod cm) {
        return cm.proceed();
    }

    protected void afterReturning(ClassMethod cm) {
        Map connections = (Map)App.get("NLF_CONNECTION");
        if (null != connections) {
            for (IConnection connection : connections.values()) {
                connection.close();
            }
        }
    }

    protected Object afterThrowing(ClassMethod cm, Throwable e) {
        Throwable cause;
        Logger.getLog().error(App.getProperty("nlf.dispatcher.request_failed", cm + ""), e);
        for (cause = e; null != cause && null != cause.getCause(); cause = cause.getCause()) {
        }
        return cause;
    }
}

