/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao;

import com.nlf.App;
import com.nlf.dao.AbstractDao;
import com.nlf.dao.IDao;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.DbSettingFactory;
import com.nlf.dao.setting.IDbSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DaoFactory {
    protected static final Map<String, String> daos = new HashMap<String, String>();

    public static IDao getDao(String alias) {
        if (!daos.containsKey(alias)) {
            IDbSetting setting = DbSettingFactory.getSetting(alias);
            List<String> impls = App.getImplements(IDao.class);
            for (String klass : impls) {
                AbstractDao dao = (AbstractDao)App.getProxy().newInstance(klass);
                if (!dao.support(setting.getDbType())) continue;
                daos.put(alias, klass);
                dao.setAlias(alias);
                return dao;
            }
            daos.put(alias, null);
        } else {
            String impl = daos.get(alias);
            if (null != impl) {
                AbstractDao dao = (AbstractDao)App.getProxy().newInstance(impl);
                dao.setAlias(alias);
                return dao;
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.not_found", alias));
    }

    public static IDao getDao() {
        return DaoFactory.getDao(DbSettingFactory.getDefaultSetting().getAlias());
    }
}

