/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.core.IRequest;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.ISqlTemplate;
import com.nlf.extend.dao.sql.ResultSetIterator;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.log.Logger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASqlTemplate
extends AbstractSqlExecuter
implements ISqlTemplate {
    protected List<String> sqls = new ArrayList<String>();
    protected Bean param = new Bean();

    @Override
    public ISqlTemplate sql(String sql) {
        this.sqls.add(sql);
        return this;
    }

    @Override
    public ISqlTemplate sqlIf(String sql, boolean condition) {
        if (condition) {
            this.sql(sql);
        }
        return this;
    }

    @Override
    public ISqlTemplate param(Bean param) {
        for (Map.Entry<String, Object> en : param.entrySet()) {
            this.param(en.getKey(), en.getValue());
        }
        return this;
    }

    @Override
    public ISqlTemplate param(String key, Object value) {
        this.param.set(key, value);
        return this;
    }

    @Override
    protected String buildSql() {
        StringBuilder s = new StringBuilder();
        for (String sql : this.sqls) {
            s.append(sql);
        }
        return s.toString();
    }

    protected List<Bean> query(String sql) {
        List<Bean> list;
        this.params.clear();
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            list = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        return list;
    }

    @Override
    public List<Bean> query() {
        return this.query(this.buildSql());
    }

    @Override
    public List<Bean> top(int count) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public Bean topOne() {
        List<Bean> l = this.top(1);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public Bean one() {
        List<Bean> l = this.query();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public int count() {
        List<Bean> l = this.query("SELECT COUNT(*) NLFCOUNT_ FROM (" + this.buildSql() + ") NLFTABLE_");
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public PageData paging() {
        IRequest r = App.getRequest();
        return this.page(r.getPageNumber(), r.getPageSize());
    }

    @Override
    public int update() {
        int n;
        PreparedStatement stmt;
        block5: {
            this.params.clear();
            this.sql = this.buildParams(this.buildSql(), this.param);
            Logger.getLog().debug(this.buildLog());
            stmt = null;
            SqlConnection conn = (SqlConnection)this.connection;
            stmt = conn.getConnection().prepareStatement(this.sql);
            conn.setStatement(stmt);
            this.bindParams(stmt);
            if (!conn.isInBatch()) break block5;
            stmt.addBatch();
            int n2 = -1;
            this.finalize(stmt);
            return n2;
        }
        try {
            n = stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt);
                throw throwable;
            }
        }
        this.finalize(stmt);
        return n;
    }

    @Override
    public Iterator<Bean> iterator() {
        this.params.clear();
        this.sql = this.buildParams(this.buildSql(), this.param);
        Logger.getLog().debug(this.buildLog());
        ResultSetIterator iterator = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            iterator = new ResultSetIterator(rs);
        }
        catch (SQLException e) {
            this.finalize(stmt, rs);
            throw new DaoException(e);
        }
        return iterator;
    }
}

