/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.oracle;

import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.extend.dao.sql.dbType.common.ASqlSelecter;
import com.nlf.log.Logger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSelecter
extends ASqlSelecter {
    @Override
    public boolean support(String dbType) {
        return "oracle".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        List<Bean> list;
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = "SELECT * FROM (" + this.sql + ") WHERE ROWNUM <= " + count;
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            list = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        return list;
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = "SELECT * FROM (SELECT NLFTABLE_.*,ROWNUM RN_ FROM (" + this.sql + ") NLFTABLE_ WHERE ROWNUM <= " + d.getPageNumber() * d.getPageSize() + ") WHERE RN_ > " + (d.getPageNumber() - 1) * d.getPageSize();
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<Bean> l = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            l = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        d.setData(l);
        return d;
    }
}

