/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.sqlserver;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.SqlConnection;
import com.nlf.extend.dao.sql.dbType.common.ASqlTemplate;
import com.nlf.log.Logger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlserverTemplate
extends ASqlTemplate {
    @Override
    public boolean support(String dbType) {
        return "sqlserver".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        List<Bean> list;
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + count + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            list = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        return list;
    }

    @Override
    public int count() {
        this.params.clear();
        this.sql = this.buildSql();
        this.sql = this.sql.replace("\r", " ").replace("\n", " ");
        String upperSql = this.sql.toUpperCase();
        int orderIndex = upperSql.indexOf(" ORDER ");
        if (orderIndex > -1) {
            this.sql = this.sql.substring(0, orderIndex);
        }
        this.sql = "SELECT COUNT(*) NLFCOUNT_ FROM (" + this.sql + ") NLFTABLE_";
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<Bean> l = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(this.sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            l = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + d.getPageNumber() * d.getPageSize() + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        PreparedStatement stmt = null;
        ResultSet rs = null;
        List<Bean> l = null;
        try {
            stmt = ((SqlConnection)this.connection).getConnection().prepareStatement(sql);
            this.bindParams(stmt);
            rs = stmt.executeQuery();
            rs.absolute((d.getPageNumber() - 1) * d.getPageSize());
            l = this.toBeans(rs);
        }
        catch (SQLException e) {
            try {
                throw new DaoException(e);
            }
            catch (Throwable throwable) {
                this.finalize(stmt, rs);
                throw throwable;
            }
        }
        this.finalize(stmt, rs);
        d.setData(l);
        return d;
    }
}

