/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.serialize.xml.impl;

import com.nlf.exception.NlfException;
import com.nlf.extend.serialize.xml.exception.XmlFormatException;
import com.nlf.serialize.AbstractParser;
import com.nlf.serialize.node.INode;
import com.nlf.serialize.node.impl.NodeList;
import com.nlf.serialize.node.impl.NodeMap;
import com.nlf.serialize.node.impl.NodeString;
import com.nlf.util.StringUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DefaultXmlParser
extends AbstractParser {
    public static final String CDATA_PREFIX = "![CDATA[";
    public static final String CDATA_SUFFIX = "]]";
    public static final String ANNO_PREFIX = "!--";
    public static final String ANNO_SUFFIX = "--";
    private int c;
    private String os;
    private Reader reader;
    private List<INode> stack = new ArrayList<INode>();

    public boolean support(String format) {
        return "xml".equalsIgnoreCase(format);
    }

    public INode parseAll(String s) {
        this.os = s;
        if (null == s) {
            return null;
        }
        s = s.trim();
        s = s.substring(s.indexOf("<"));
        this.reader = new StringReader(s);
        while (-1 != this.c) {
            this.parseNode();
        }
        return this.stack.get(0);
    }

    protected void parseNode() {
        this.skip();
        switch (this.c) {
            case 60: {
                this.parseXmlNode();
                break;
            }
            default: {
                String s = this.readUntil(60);
                INode p = this.stack.get(this.stack.size() - 1);
                try {
                    ((NodeString)p).setValue(s.replace("&lt;", "<").replace("&gt;", ">"));
                    break;
                }
                catch (Exception e) {
                    throw new XmlFormatException(s);
                }
            }
        }
    }

    private void parseEndTag(String tag) {
        int stackSize = this.stack.size();
        if (stackSize < 2) {
            return;
        }
        INode el = this.stack.remove(stackSize - 1);
        INode p = this.stack.get(--stackSize - 1);
        switch (p.type()) {
            case LIST: {
                ((NodeList)p).add(el);
                break;
            }
            case MAP: {
                NodeMap map = (NodeMap)p;
                INode xe = map.get(tag);
                if (null != xe) {
                    NodeList xl = new NodeList();
                    xl.setName(p.getName());
                    xl.setAttributes(p.getAttributes());
                    xl.add(xe);
                    xl.add(el);
                    this.stack.set(stackSize - 1, xl);
                }
                map.set(tag, el);
                break;
            }
            case STRING: {
                NodeMap m = new NodeMap();
                m.setName(p.getName());
                m.setAttributes(p.getAttributes());
                m.set(tag, el);
                this.stack.set(stackSize - 1, m);
                break;
            }
        }
    }

    private void parseXmlNode() {
        this.next();
        switch (this.c) {
            case 63: {
                this.readUntil(62);
                this.next();
                break;
            }
            case 33: {
                String s = this.readUntil(62).trim();
                String us = s.toUpperCase();
                if (us.startsWith(CDATA_PREFIX)) {
                    while (!us.endsWith(CDATA_SUFFIX)) {
                        this.next();
                        if (-1 == this.c) {
                            throw new XmlFormatException(this.os);
                        }
                        us = this.readUntil(62);
                        s = s + ">" + us;
                        us = us.toUpperCase();
                    }
                    s = s.substring(CDATA_PREFIX.length());
                    s = s.substring(0, s.length() - CDATA_SUFFIX.length());
                    int stackSize = this.stack.size();
                    if (stackSize > 0) {
                        INode p = this.stack.get(stackSize - 1);
                        ((NodeString)p).setValue(s);
                    }
                } else if (us.startsWith(ANNO_PREFIX)) {
                    StringBuffer n = new StringBuffer();
                    n.append(s);
                    while (!us.endsWith(ANNO_SUFFIX)) {
                        this.next();
                        if (-1 == this.c) {
                            throw new XmlFormatException(this.os);
                        }
                        us = this.readUntil(62);
                        n.append(us);
                        us = us.toUpperCase();
                    }
                }
                this.next();
                break;
            }
            case 47: {
                this.next();
                String tag = this.readUntil(62);
                this.next();
                this.parseEndTag(tag);
                break;
            }
            default: {
                String startTag = this.readUntil(62);
                this.next();
                boolean isClosed = false;
                startTag = startTag.trim();
                if (startTag.endsWith("/")) {
                    isClosed = true;
                    startTag = startTag.substring(0, startTag.length() - 1);
                }
                String nodeName = startTag;
                HashMap<String, String> attrs = new HashMap<String, String>();
                if (startTag.contains(" ")) {
                    nodeName = StringUtil.between(startTag, "", " ");
                    String attr = StringUtil.right(startTag, " ");
                    while (attr.contains("=\"")) {
                        String attrName = StringUtil.between(attr, "", "=\"").trim();
                        attr = StringUtil.right(attr, "=\"");
                        String attrValue = StringUtil.left(attr, "\"").trim();
                        attr = StringUtil.right(attr, "\"");
                        attrs.put(attrName, attrValue);
                    }
                }
                NodeString xs = new NodeString(null);
                xs.setName(nodeName);
                xs.setAttributes(attrs);
                this.stack.add(xs);
                if (!isClosed) break;
                this.parseEndTag(nodeName);
            }
        }
    }

    private String readUntil(int endTag) {
        StringBuilder s = new StringBuilder();
        while (-1 != this.c && endTag != this.c) {
            s.append((char)this.c);
            this.next();
        }
        return s.toString();
    }

    protected void next() {
        try {
            this.c = this.reader.read();
        }
        catch (IOException e) {
            throw new NlfException(e);
        }
    }

    protected void skip() {
        if (-1 == this.c) {
            return;
        }
        if (0 <= this.c && 32 >= this.c) {
            this.next();
            this.skip();
        }
        if (127 == this.c || 13 == this.c || 10 == this.c) {
            this.next();
            this.skip();
        }
    }
}

