/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.serialize.json.impl;

import com.nlf.Bean;
import com.nlf.dao.paging.PageData;
import com.nlf.serialize.AbstractWrapper;
import com.nlf.util.Base64Util;
import com.nlf.util.DateUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class DefaultJsonWrapper
extends AbstractWrapper {
    protected String quote = "\"";

    protected String wrapNumber(Object o) {
        return o + "";
    }

    protected String wrapBool(Object o) {
        return o + "";
    }

    protected String wrapString(Object o) {
        String s = o + "";
        s = s.replace("\\", "\\\\");
        s = s.replace("\b", "\\b");
        s = s.replace("\t", "\\t");
        s = s.replace("\n", "\\n");
        s = s.replace("\f", "\\f");
        s = s.replace("\r", "\\r");
        s = s.replace("\"", "\\\"");
        return this.quote + s + this.quote;
    }

    protected String wrapDate(Object o) {
        return this.wrapString(DateUtil.ymdhms((Date)o));
    }

    protected String wrapByteArray(Object o) {
        byte[] d = (byte[])o;
        return this.wrapString(Base64Util.encode(d));
    }

    protected String wrapArray(Object o) {
        if (o instanceof byte[]) {
            return this.wrapByteArray(o);
        }
        Object[] l = (Object[])o;
        return this.wrapCollection(Arrays.asList(l));
    }

    protected String wrapCollection(Object o) {
        Collection l = (Collection)o;
        StringBuilder s = new StringBuilder();
        s.append("[");
        Iterator it = l.iterator();
        while (it.hasNext()) {
            s.append(this.wrap(it.next()));
            if (!it.hasNext()) continue;
            s.append(",");
        }
        s.append("]");
        return s.toString();
    }

    protected String wrapMap(Object o) {
        Map m = (Map)o;
        StringBuilder s = new StringBuilder();
        s.append("{");
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            s.append(this.wrapString(key + ""));
            s.append(":");
            s.append(this.wrap(m.get(key)));
            if (!it.hasNext()) continue;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    protected String wrapBean(Object o) {
        Bean bean = (Bean)o;
        StringBuilder s = new StringBuilder();
        s.append("{");
        Iterator<String> it = bean.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            s.append(this.wrapString(key));
            s.append(":");
            s.append(this.wrap(bean.get(key)));
            if (!it.hasNext()) continue;
            s.append(",");
        }
        s.append("}");
        return s.toString();
    }

    protected String wrapObject(Object o) {
        try {
            StringBuilder s = new StringBuilder();
            s.append("{");
            BeanInfo info = Introspector.getBeanInfo(o.getClass(), Object.class);
            PropertyDescriptor[] props = info.getPropertyDescriptors();
            if (props.length > 0) {
                for (int i = 0; i < props.length; ++i) {
                    PropertyDescriptor desc = props[i];
                    s.append(this.wrapString(desc.getName()));
                    s.append(":");
                    Method method = desc.getReadMethod();
                    if (null == method) {
                        s.append(this.wrap(null));
                    } else {
                        s.append(this.wrap(method.invoke(o, new Object[0])));
                    }
                    if (i >= props.length - 1) continue;
                    s.append(",");
                }
            }
            s.append("}");
            return s.toString();
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    public String wrap(Object o) {
        StringBuilder s = new StringBuilder();
        if (null == o) {
            s.append("null");
        } else if (o instanceof Number) {
            s.append(this.wrapNumber(o));
        } else if (o instanceof Boolean) {
            s.append(this.wrapBool(o));
        } else if (o instanceof Character || o instanceof String) {
            s.append(this.wrapString(o));
        } else if (o instanceof Date) {
            s.append(this.wrapDate(o));
        } else if (o.getClass().isArray()) {
            s.append(this.wrapArray(o));
        } else if (o instanceof PageData) {
            s.append(this.wrapObject(o));
        } else if (o instanceof Collection) {
            s.append(this.wrapCollection(o));
        } else if (o instanceof Map) {
            s.append(this.wrapMap(o));
        } else if (o instanceof Enum) {
            s.append(this.wrapString(o));
        } else if (o instanceof Bean) {
            s.append(this.wrapBean(o));
        } else {
            s.append(this.wrapObject(o));
        }
        return s.toString();
    }

    public boolean support(String format) {
        return "json".equalsIgnoreCase(format);
    }
}

