/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtil {
    public static final Set<Character> REG_KEYS = new HashSet<Character>(Arrays.asList(Character.valueOf('$'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('+'), Character.valueOf('.'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('\\'), Character.valueOf('^'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('|')));

    public static List<String> list(String s, String separator) {
        int offset;
        String[] arr = s.split(separator, -1);
        ArrayList<String> l = new ArrayList<String>(arr.length);
        Collections.addAll(l, arr);
        if (!s.startsWith(separator) && l.size() > 0 && ((String)l.get(0)).length() < 1) {
            l.remove(0);
        }
        if (!s.endsWith(separator) && (offset = l.size()) > 0 && ((String)l.get(--offset)).length() < 1) {
            l.remove(offset);
        }
        return l;
    }

    public static String[] array(String s, String separator) {
        List<String> l = StringUtil.list(s, separator);
        int size = l.size();
        String[] arr = new String[size];
        for (int i = 0; i < size; ++i) {
            arr[i] = l.get(i);
        }
        return arr;
    }

    public static String join(String[] array, String separator) {
        if (null == array) {
            return "";
        }
        int len = array.length;
        if (len < 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(array[i]);
        }
        return sb + "";
    }

    public static String join(Collection<String> l, String separator) {
        if (null == l) {
            return "";
        }
        if (l.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : l) {
            if (i++ > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb + "";
    }

    public static String between(String s, String start, String end) {
        int idx = s.indexOf(start);
        if (idx > -1) {
            String k = s.substring(idx + start.length());
            return (idx = k.indexOf(end)) > 0 ? k.substring(0, idx) : "";
        }
        return "";
    }

    public static String right(String s, String start) {
        int idx = s.indexOf(start);
        return idx > -1 ? s.substring(idx + start.length()) : "";
    }

    public static String left(String s, String end) {
        int idx = s.indexOf(end);
        return idx > 0 ? s.substring(0, idx) : "";
    }

    public static boolean matches(String s, String expression) {
        if (null == s || null == expression) {
            return false;
        }
        int len = expression.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = expression.charAt(i);
            if ('?' == c) {
                sb.append(".{1}");
                continue;
            }
            if ('*' == c) {
                sb.append(".");
            } else if (REG_KEYS.contains(Character.valueOf(c))) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return s.matches(sb.toString());
    }
}

