/*
 * Decompiled with CFR 0.152.
 */
package com.nlf;

import com.nlf.App;
import com.nlf.util.StringUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bean
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TYPE_CLASS_PREFIX = "class [";
    private Map<String, Object> values = new LinkedHashMap<String, Object>();

    public Bean() {
    }

    public Bean(String key, Object value) {
        this.values.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.values.containsKey(key);
    }

    public <T> T get(String key) {
        return (T)this.values.get(key);
    }

    public <E> E get(String key, Class<E> klass) {
        return (E)this.values.get(key);
    }

    public <E> E get(String key, Class<E> klass, E defaultValue) {
        Object o = this.values.get(key);
        return (E)(null == o ? defaultValue : o);
    }

    protected Object convertString(String object, String type) {
        Object value = object;
        if ("byte".equals(type)) {
            value = Byte.parseByte(object);
        } else if ("short".equals(type)) {
            value = Short.parseShort(object);
        } else if ("int".equals(type)) {
            value = Integer.parseInt(object);
        } else if ("long".equals(type)) {
            value = Long.parseLong(object);
        } else if ("float".equals(type)) {
            value = Float.valueOf(Float.parseFloat(object));
        } else if ("double".equals(type)) {
            value = Double.parseDouble(object);
        }
        return value;
    }

    protected Object convertInteger(int object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = (byte)object;
        } else if ("short".equals(type)) {
            value = (short)object;
        }
        return value;
    }

    protected Object convertDouble(double object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = (byte)object;
        } else if ("short".equals(type)) {
            value = (short)object;
        } else if ("int".equals(type)) {
            value = (int)object;
        } else if ("long".equals(type)) {
            value = (long)object;
        } else if ("float".equals(type)) {
            value = Float.valueOf((float)object);
        }
        return value;
    }

    protected Object convertBigDecimal(BigDecimal object, String type) {
        Number value = object;
        if ("byte".equals(type)) {
            value = object.byteValue();
        } else if ("short".equals(type)) {
            value = object.shortValue();
        } else if ("int".equals(type)) {
            value = object.intValue();
        } else if ("long".equals(type)) {
            value = object.longValue();
        } else if ("float".equals(type)) {
            value = Float.valueOf(object.floatValue());
        } else if ("double".equals(type)) {
            value = object.doubleValue();
        }
        return value;
    }

    protected Object convert(Object object, Class<?> propType, Type paramType) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        Object value = object;
        String paramTypeString = paramType + "";
        if (null != object) {
            if (value instanceof Integer) {
                value = this.convertInteger((Integer)value, paramTypeString);
            } else if (value instanceof BigDecimal) {
                value = this.convertBigDecimal((BigDecimal)value, paramTypeString);
            } else if (value instanceof Double) {
                value = this.convertDouble((Double)value, paramTypeString);
            } else if (value instanceof String) {
                value = this.convertString((String)value, paramTypeString);
            } else if (value instanceof Bean) {
                value = ((Bean)value).toObject(propType);
            } else if (value instanceof List) {
                Type elType = propType.getComponentType();
                if (null == elType) {
                    elType = ((ParameterizedType)paramType).getActualTypeArguments()[0];
                }
                List l = (List)value;
                int size = l.size();
                HashMap cache = new HashMap(size);
                int j = l.size();
                for (int i = 0; i < j; ++i) {
                    Object el = l.get(i);
                    if (!(el instanceof Bean)) continue;
                    cache.put(i, ((Bean)el).toObject((Class)elType));
                }
                for (Map.Entry entry : cache.entrySet()) {
                    l.set((Integer)entry.getKey(), entry.getValue());
                }
                if (paramTypeString.startsWith(Set.class.getName())) {
                    value = new HashSet(l);
                } else if (paramTypeString.startsWith(Queue.class.getName())) {
                    value = new LinkedList(l);
                } else if (paramTypeString.startsWith(TYPE_CLASS_PREFIX)) {
                    value = Array.newInstance(elType, size);
                    for (int i = 0; i < size; ++i) {
                        Array.set(value, i, l.get(i));
                    }
                }
            }
        }
        return value;
    }

    public <E> E toObject(Class<E> klass) throws IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (Bean.class.equals(klass) || Map.class.equals(klass)) {
            return (E)this;
        }
        E ret = null;
        int lastMatchedKeyCount = 0;
        List<String> impls = App.getImplements(klass);
        for (String c : impls) {
            PropertyDescriptor[] props;
            int matchedKeyCount = 0;
            Object o = App.getProxy().newInstance(c);
            BeanInfo info = Introspector.getBeanInfo(o.getClass(), Object.class);
            block1: for (PropertyDescriptor p : props = info.getPropertyDescriptors()) {
                Method setterMethod = p.getWriteMethod();
                if (null == setterMethod) continue;
                Class<?> propType = p.getPropertyType();
                Type paramType = setterMethod.getGenericParameterTypes()[0];
                String name = p.getName();
                for (String key : this.keySet()) {
                    if (!key.equalsIgnoreCase(name)) continue;
                    setterMethod.invoke(o, this.convert(this.get(key), propType, paramType));
                    ++matchedKeyCount;
                    continue block1;
                }
            }
            if (matchedKeyCount <= lastMatchedKeyCount) continue;
            lastMatchedKeyCount = matchedKeyCount;
            ret = (E)o;
        }
        return ret;
    }

    public Bean set(String key, Object value) {
        this.values.put(key, value);
        return this;
    }

    public Bean setIf(String key, Object value, boolean condition) {
        if (condition) {
            this.values.put(key, value);
        }
        return this;
    }

    public Bean remove(String key) {
        this.values.remove(key);
        return this;
    }

    @Override
    public Set<String> keySet() {
        return this.values.keySet();
    }

    public String toString() {
        return this.values.toString();
    }

    public <T> T select(String path) {
        if (null == path) {
            return null;
        }
        List<String> paths = StringUtil.list(path, "\\.");
        int depth = paths.size();
        if (depth < 1) {
            return null;
        }
        String leaf = paths.remove(depth - 1);
        Bean node = this;
        for (String p : paths) {
            if (p.contains("[") && p.contains("]")) {
                String key = StringUtil.left(p, "[");
                int index = Integer.parseInt(StringUtil.between(p, "[", "]"));
                node = node.getList(key, Bean.class).get(index);
                continue;
            }
            node = node.getList(p, Bean.class).get(0);
        }
        if (leaf.contains("[") && leaf.contains("]")) {
            String key = StringUtil.left(leaf, "[");
            int index = Integer.parseInt(StringUtil.between(leaf, "[", "]"));
            return node.getList(key).get(index);
        }
        return node.getList(leaf).get(0);
    }

    public Bean getBean(String key) {
        return (Bean)this.get(key);
    }

    public Bean selectBean(String path) {
        return (Bean)this.select(path);
    }

    public Bean getBean(String key, Bean defaultValue) {
        Bean v = null;
        try {
            v = (Bean)this.get(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null == v ? defaultValue : v;
    }

    public Bean selectBean(String path, Bean defaultValue) {
        Bean v = null;
        try {
            v = this.selectBean(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null == v ? defaultValue : v;
    }

    public short getShort(String key, short defaultValue) {
        try {
            return Short.parseShort(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public short selectShort(String path, short defaultValue) {
        try {
            return Short.parseShort(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int selectInt(String path, int defaultValue) {
        try {
            return Integer.parseInt(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long getLong(String key, long defaultValue) {
        try {
            return Long.parseLong(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public long selectLong(String path, long defaultValue) {
        try {
            return Long.parseLong(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return Double.parseDouble(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double selectDouble(String path, double defaultValue) {
        try {
            return Double.parseDouble(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public float selectFloat(String path, float defaultValue) {
        try {
            return Float.parseFloat(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(String.valueOf(this.values.get(key)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean selectBoolean(String path, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(String.valueOf(this.select(path)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String selectString(String path) {
        return this.selectString(path, null);
    }

    public String getString(String key, String defaultValue) {
        Object o = this.values.get(key);
        return null == o ? defaultValue : o.toString();
    }

    public String selectString(String path, String defaultValue) {
        Object o = this.select(path);
        return null == o ? defaultValue : o.toString();
    }

    public <T> List<T> getList(String key) {
        ArrayList<Object> l = new ArrayList<Object>();
        Object o = this.values.get(key);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    public <T> List<T> selectList(String path) {
        ArrayList<T> l = new ArrayList<T>();
        T o = this.select(path);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    public <E> List<E> getList(String key, Class<E> klass) {
        ArrayList<Object> l = new ArrayList<Object>();
        Object o = this.values.get(key);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    public <E> List<E> selectList(String path, Class<E> klass) {
        ArrayList l = new ArrayList();
        Object o = this.select(path);
        if (null == o) {
            return l;
        }
        if (o instanceof Collection) {
            l.addAll((Collection)o);
        } else {
            l.add(o);
        }
        return l;
    }

    @Override
    @Deprecated
    public boolean containsKey(Object key) {
        return this.containsKey(key + "");
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.values.entrySet();
    }

    @Override
    @Deprecated
    public Object get(Object key) {
        return this.values.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    @Deprecated
    public Object put(String key, Object value) {
        return this.values.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.values.putAll(map);
    }

    @Override
    @Deprecated
    public Object remove(Object key) {
        return this.values.remove(key);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Collection<Object> values() {
        return this.values.values();
    }

    @Override
    public void clear() {
        this.values.clear();
    }
}

