/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.core;

import com.nlf.core.IScanner;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractScanner
implements IScanner {
    protected String caller;
    protected Set<String> addedAbsolutePaths = new HashSet<String>();
    protected Set<String> addedRelativePaths = new HashSet<String>();
    protected Set<String> ignoredPaths = new HashSet<String>();
    protected Set<String> allowPaths = new HashSet<String>();
    protected Map<String, Set<String>> ignoredManifestAttributes = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> allowManifestAttributes = new HashMap<String, Set<String>>();

    public IScanner setCaller(String caller) {
        this.caller = caller;
        return this;
    }

    public IScanner addAbsolutePath(String ... path) {
        Collections.addAll(this.addedAbsolutePaths, path);
        return this;
    }

    public IScanner addRelativePath(String ... path) {
        Collections.addAll(this.addedRelativePaths, path);
        return this;
    }

    public IScanner ignore(String ... path) {
        Collections.addAll(this.ignoredPaths, path);
        return this;
    }

    public IScanner allow(String ... path) {
        Collections.addAll(this.allowPaths, path);
        return this;
    }

    public IScanner ignoreJarByManifestAttribute(String key, String ... value) {
        Set<String> values = this.ignoredManifestAttributes.get(key);
        if (null == values) {
            values = new HashSet<String>();
            this.ignoredManifestAttributes.put(key, values);
        }
        Collections.addAll(values, value);
        return this;
    }

    public IScanner allowJarByManifestAttribute(String key, String ... value) {
        Set<String> values = this.allowManifestAttributes.get(key);
        if (null == values) {
            values = new HashSet<String>();
            this.allowManifestAttributes.put(key, values);
        }
        Collections.addAll(values, value);
        return this;
    }
}

