/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql;

import com.nlf.Bean;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetIterator
implements Iterator<Bean> {
    private ResultSet rs;
    private boolean calledHasNext;
    private boolean hasNext;

    public ResultSetIterator(ResultSet rs) {
        this.rs = rs;
    }

    @Override
    public boolean hasNext() {
        if (this.calledHasNext) {
            return this.hasNext;
        }
        try {
            this.hasNext = this.rs.next();
        }
        catch (SQLException e) {
            this.hasNext = false;
        }
        finally {
            this.calledHasNext = true;
        }
        return this.hasNext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bean next() {
        if (!this.calledHasNext) {
            this.hasNext();
        }
        try {
            ResultSetMetaData rsmd = this.rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            Bean o = new Bean();
            for (int i = 0; i < columnCount; ++i) {
                o.set(rsmd.getColumnName(i + 1), this.rs.getObject(i + 1));
            }
            Bean bean = o;
            return bean;
        }
        catch (SQLException e) {
            Bean bean = null;
            return bean;
        }
        finally {
            this.calledHasNext = false;
        }
    }

    @Override
    public void remove() {
    }
}

