/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql;

import com.nlf.dao.connection.AbstractConnection;
import com.nlf.dao.exception.DaoException;
import com.nlf.util.IOUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class SqlConnection
extends AbstractConnection {
    protected boolean inBatch;
    protected PreparedStatement statement;
    protected Connection connection;

    public SqlConnection(Connection connection) {
        this.connection = connection;
        try {
            this.supportBatchUpdate = connection.getMetaData().supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void close() {
        IOUtil.closeQuietly(this.connection);
    }

    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new DaoException(e);
        }
    }

    public boolean isInBatch() {
        return this.inBatch;
    }

    public void setInBatch(boolean inBatch) {
        this.inBatch = inBatch;
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public void setStatement(PreparedStatement statement) {
        this.statement = statement;
    }
}

