/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.Bean;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ConditionType;
import com.nlf.extend.dao.sql.ISqlUpdater;
import com.nlf.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ASqlUpdater
extends AbstractSqlExecuter
implements ISqlUpdater {
    protected List<Condition> columns = new ArrayList<Condition>();

    public ISqlUpdater table(String tables) {
        this.tables.add(tables);
        return this;
    }

    public ISqlUpdater tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    public String buildSql() {
        StringBuilder s = new StringBuilder();
        s.append("UPDATE ");
        s.append(StringUtil.join(this.tables, ","));
        s.append(" SET ");
        int j = this.columns.size();
        for (int i = 0; i < j; ++i) {
            s.append(i < 1 ? "" : ",");
            s.append(this.buildSqlParams(this.columns.get(i)));
        }
        s.append(this.buildSqlWhere());
        return s.toString();
    }

    public int update() {
        return this.executeUpdate();
    }

    public ISqlUpdater set(String sql) {
        Condition cond = new Condition();
        cond.setType(ConditionType.pure_sql);
        cond.setColumn(sql);
        cond.setStart("");
        cond.setPlaceholder("");
        cond.setEnd("");
        this.columns.add(cond);
        return this;
    }

    public ISqlUpdater set(String columnOrSql, Object valueOrBean) {
        Condition cond = new Condition();
        cond.setColumn(columnOrSql);
        cond.setValue(valueOrBean);
        cond.setEnd("");
        if (null != valueOrBean && columnOrSql.contains(":") && valueOrBean instanceof Bean) {
            cond.setType(ConditionType.multi_params);
            cond.setStart("");
            cond.setPlaceholder("");
        } else {
            cond.setType(ConditionType.one_param);
            cond.setStart("=");
            cond.setPlaceholder("?");
        }
        this.columns.add(cond);
        return this;
    }

    public ISqlUpdater set(Bean bean) {
        for (String key : bean.keySet()) {
            this.set(key, bean.get(key));
        }
        return this;
    }

    public ISqlUpdater setIf(String sql, boolean condition) {
        if (condition) {
            this.set(sql);
        }
        return this;
    }

    public ISqlUpdater setIf(String columnOrSql, Object valueOrBean, boolean condition) {
        if (condition) {
            this.set(columnOrSql, valueOrBean);
        }
        return this;
    }

    public ISqlUpdater setIf(Bean bean, boolean condition) {
        if (condition) {
            this.set(bean);
        }
        return this;
    }

    public ISqlUpdater where(String sql) {
        super.where(sql);
        return this;
    }

    public ISqlUpdater where(String columnOrSql, Object valueOrBean) {
        super.where(columnOrSql, valueOrBean);
        return this;
    }

    public ISqlUpdater whereIf(String sql, boolean condition) {
        if (condition) {
            this.where(sql);
        }
        return this;
    }

    public ISqlUpdater whereIf(String columnOrSql, Object valueOrBean, boolean condition) {
        if (condition) {
            this.where(columnOrSql, valueOrBean);
        }
        return this;
    }

    public ISqlUpdater whereIn(String column, Object ... values) {
        super.whereIn(column, values);
        return this;
    }

    public ISqlUpdater whereNotIn(String column, Object ... values) {
        super.whereNotIn(column, values);
        return this;
    }

    public ISqlUpdater whereNotEqual(String column, Object value) {
        super.whereNotEqual(column, value);
        return this;
    }
}

