/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.web.view;

import com.nlf.extend.web.WebView;
import com.nlf.util.ContentTypes;
import java.io.InputStream;

public class StreamView
extends WebView {
    protected InputStream inputStream;
    protected String name;
    protected String contentType = "application/octet-stream";
    protected long size = -1L;

    public StreamView(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public StreamView(InputStream inputStream, String name) {
        this(inputStream);
        this.setName(name);
    }

    public StreamView(InputStream inputStream, String name, long size) {
        this(inputStream, name);
        this.setSize(size);
    }

    public StreamView(InputStream inputStream, String name, String contentType) {
        this(inputStream, name);
        this.setContentType(contentType);
    }

    public StreamView(InputStream inputStream, String name, String contentType, long size) {
        this(inputStream, name, contentType);
        this.setSize(size);
    }

    public String getName() {
        return this.name;
    }

    public StreamView setName(String name) {
        this.name = name;
        if (name.contains(".")) {
            String ext = name.substring(name.lastIndexOf("."));
            this.setContentType(ContentTypes.getContentType(ext));
        }
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public StreamView setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public long getSize() {
        return this.size;
    }

    public StreamView setSize(long size) {
        this.size = size;
        return this;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public StreamView setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }
}

