/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.util.regex.Pattern;

public class Base64Util {
    private static final int MIN_UNIT_SIZE = 4;
    private static final int MAP1_SIZE = 64;
    private static final int MAP2_SIZE = 128;
    private static final char[] MAP1;
    private static final byte[] MAP2;

    private Base64Util() {
    }

    public static boolean isBase64(String s) {
        return Pattern.matches("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$", s);
    }

    public static String encode(byte[] in) {
        int iOff = 0;
        int iLen = in.length;
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = MAP1[o0];
            out[op++] = MAP1[o1];
            out[op] = op < oDataLen ? MAP1[o2] : 61;
            int n = ++op < oDataLen ? MAP1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return new String(out);
    }

    public static byte[] decode(String s) {
        char[] in = s.toCharArray();
        int iOff = 0;
        int iLen = in.length;
        if (iLen % 4 != 0) {
            throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
        }
        while (iLen > 0 && in[iOff + iLen - 1] == '=') {
            --iLen;
        }
        int oLen = iLen * 3 / 4;
        byte[] out = new byte[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i3;
            char i0 = in[ip++];
            char i1 = in[ip++];
            int i2 = ip < iEnd ? in[ip++] : 65;
            int n = i3 = ip < iEnd ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            byte b0 = MAP2[i0];
            byte b1 = MAP2[i1];
            byte b2 = MAP2[i2];
            byte b3 = MAP2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            int o0 = b0 << 2 | b1 >>> 4;
            int o1 = (b1 & 0xF) << 4 | b2 >>> 2;
            int o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    static {
        int c;
        MAP1 = new char[64];
        MAP2 = new byte[128];
        int i = 0;
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            Base64Util.MAP1[i++] = c;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            Base64Util.MAP1[i++] = c;
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            Base64Util.MAP1[i++] = c;
        }
        Base64Util.MAP1[i++] = 43;
        Base64Util.MAP1[i] = 47;
        for (i = 0; i < 128; ++i) {
            Base64Util.MAP2[i] = -1;
        }
        for (i = 0; i < 64; ++i) {
            Base64Util.MAP2[Base64Util.MAP1[i]] = (byte)i;
        }
    }
}

