/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArray {
    private static final int HEX_UNIT_LENGTH = 2;
    private List<Byte> l = new ArrayList<Byte>();

    public ByteArray() {
    }

    public ByteArray(byte[] d) {
        this.append(d);
    }

    public ByteArray(List<Byte> d) {
        this.append(d);
    }

    public byte[] removeHead(int n) {
        byte[] d = new byte[n];
        for (int i = 0; i < n; ++i) {
            d[i] = this.l.remove(0);
        }
        return d;
    }

    public byte[] removeTail(int n) {
        byte[] d = new byte[n];
        for (int i = 0; i < n; ++i) {
            d[n - i - 1] = this.l.remove(this.size() - 1);
        }
        return d;
    }

    public ByteArray getHead(int n) {
        return this.sub(0, n);
    }

    public byte[] getHeads(int n) {
        return this.getHead(n).toArray();
    }

    public ByteArray getTail(int n) {
        int l = this.size();
        return this.sub(l - n, l);
    }

    public byte[] getTails(int n) {
        return this.getTail(n).toArray();
    }

    public ByteArray clear() {
        this.l.clear();
        return this;
    }

    public ByteArray set(int index, byte b) {
        this.l.set(index, b);
        return this;
    }

    public int size() {
        return this.l.size();
    }

    public byte get(int index) {
        return this.l.get(index);
    }

    public ByteArray sub(int fromIndex, int toIndex) {
        return new ByteArray(this.l.subList(fromIndex, toIndex));
    }

    public ByteArray append(byte b) {
        this.l.add(b);
        return this;
    }

    public ByteArray append(byte[] data) {
        for (byte b : data) {
            this.append(b);
        }
        return this;
    }

    public ByteArray append(ByteArray data) {
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            this.append(data.get(i));
        }
        return this;
    }

    public ByteArray append(List<Byte> data) {
        this.l.addAll(data);
        return this;
    }

    public byte[] toArray() {
        int n = this.size();
        byte[] b = new byte[n];
        for (int i = 0; i < n; ++i) {
            b[i] = this.l.get(i);
        }
        return b;
    }

    public int indexOf(byte[] bytes) {
        int m = bytes.length;
        int index = 0;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            byte b = this.l.get(i);
            if (b != bytes[index]) {
                index = 0;
            }
            if (b != bytes[index] || ++index < m) continue;
            return i - index + 1;
        }
        return -1;
    }

    public int indexOf(byte b) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (b != this.l.get(i)) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(ByteArray ba) {
        if (null == ba) {
            return false;
        }
        int len = this.size();
        if (len != ba.size()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.l.get(i).byteValue() == ba.get(i)) continue;
            return false;
        }
        return true;
    }

    public String toString(String prefix, String separator) {
        String pre = null == prefix ? "" : prefix;
        String sp = null == separator ? "" : separator;
        StringBuilder s = new StringBuilder();
        int j = this.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                s.append(sp);
            }
            s.append(pre);
            String h = Integer.toHexString(this.get(i) & 0xFF);
            if (h.length() < 2) {
                s.append("0");
            }
            s.append(h);
        }
        return s.toString();
    }

    public ByteArray append(String hex, String prefix) {
        String s = hex;
        int pl = prefix.length();
        if (pl > 0) {
            int start = s.indexOf(prefix);
            while (start > -1) {
                if ((s = s.substring(start + pl)).length() > 1) {
                    this.append((byte)((Character.digit(s.charAt(0), 16) << 4) + Character.digit(s.charAt(1), 16)));
                    s = s.substring(2);
                }
                start = s.indexOf(prefix);
            }
        } else {
            int l = s.length() / 2;
            byte[] b = new byte[l];
            for (int i = 0; i < l; i += 2) {
                b[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
            }
            this.append(b);
        }
        return this;
    }

    public String toString() {
        return this.toString("0x", " ");
    }
}

