/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DateUtil {
    private static final int SHORT_YEAR_LENGTH = 2;
    private static final String[] MONTH_CH = new String[]{"\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};
    private static final Map<String, String> MONTH = new HashMap<String, String>();
    private static final Map<String, String> WEEK = new HashMap<String, String>();
    private static final Map<String, String> NUMBER = new HashMap<String, String>();

    private DateUtil() {
    }

    public static Date now() {
        return new Date(System.currentTimeMillis());
    }

    public static Date ymd2Date(String ymd) throws ParseException {
        String[] f;
        String nymd = ymd.trim();
        if (!nymd.contains("-") && !nymd.contains("/")) {
            throw new ParseException("\u65e5\u671f\u683c\u5f0f\u65e0\u6cd5\u8f6c\u6362\uff1a" + ymd, 0);
        }
        String year = "";
        if (nymd.contains("-")) {
            year = nymd.substring(0, nymd.indexOf("-"));
        } else if (nymd.contains("/")) {
            year = nymd.substring(0, nymd.indexOf("/"));
        }
        if (year.length() == 2) {
            int ny = Integer.parseInt("20" + year);
            int ly = Integer.parseInt("19" + year);
            int ty = DateUtil.year(DateUtil.now());
            nymd = Math.abs(ny - ty) < Math.abs(ly - ty) ? "20" + nymd : "19" + nymd;
        }
        for (String o : f = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"}) {
            try {
                return DateUtil.parse(nymd, o);
            }
            catch (ParseException e) {
            }
        }
        throw new ParseException("\u65e5\u671f\u683c\u5f0f\u65e0\u6cd5\u8f6c\u6362\uff1a" + ymd, 0);
    }

    public static Date ymdhms2Date(String ymdhms) throws ParseException {
        return DateUtil.parse(ymdhms, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date parse(String s, String pattern) throws ParseException {
        return new SimpleDateFormat(pattern).parse(s);
    }

    public static String ymd(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd");
    }

    public static String hms(Date date) {
        return DateUtil.format(date, "HH:mm:ss");
    }

    public static String ymdhms(Date date) {
        return DateUtil.format(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(Date date, String pattern) {
        return new SimpleDateFormat(pattern).format(date);
    }

    public static Date previous(int type, Date date, int length) {
        return DateUtil.next(type, date, 0 - length);
    }

    public static Date next(int type, Date date, int length) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(type, length);
        return c.getTime();
    }

    public static Date previous(Date date, int days) {
        return DateUtil.previous(5, date, days);
    }

    public static Date next(Date date, int days) {
        return DateUtil.next(5, date, days);
    }

    public static Date nextMonth(Date date, int months) {
        return DateUtil.next(2, date, months);
    }

    public static Date previousMonth(Date date, int months) {
        return DateUtil.previous(2, date, months);
    }

    public static Date nextYear(Date date, int years) {
        return DateUtil.next(1, date, years);
    }

    public static Date previousYear(Date date, int years) {
        return DateUtil.previous(1, date, years);
    }

    public static int get(int type, Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(type);
    }

    public static int year(Date date) {
        return DateUtil.get(1, date);
    }

    public static String month(Date date) {
        int m = DateUtil.get(2, date) + 1;
        return (m < 10 ? "0" : "") + m;
    }

    public static String day(Date date) {
        int d = DateUtil.get(5, date);
        return (d < 10 ? "0" : "") + d;
    }

    public static String dm(String ymd) {
        String[] n = ymd.split("-");
        return n[2] + MONTH.get(n[1]) + n[0].substring(2);
    }

    public static String ymd(String dayMonthYear) {
        return DateUtil.ymd(dayMonthYear, "20");
    }

    public static String ymd(String dayMonthYear, String yearPrefix) {
        String s = dayMonthYear.toUpperCase();
        switch (s.length()) {
            case 4: {
                s = "0" + s;
                s = s + DateUtil.year(DateUtil.now());
                break;
            }
            case 5: {
                s = s + DateUtil.year(DateUtil.now());
                break;
            }
            case 6: {
                s = "0" + s;
                s = s.substring(0, 5) + yearPrefix + s.substring(5);
                break;
            }
            case 7: {
                s = s.substring(0, 5) + yearPrefix + s.substring(5);
                break;
            }
            case 8: {
                s = "0" + s;
                break;
            }
        }
        s = s.substring(5) + "-" + MONTH.get(s.substring(2, 5)) + "-" + s.substring(0, 2);
        return s;
    }

    public static String weekCH(Date date) {
        return WEEK.get(DateUtil.get(7, date) + "");
    }

    public static String monthCH(Date date) {
        return MONTH_CH[DateUtil.get(2, date)];
    }

    public static String yearCH(Date date) {
        String[] y = (DateUtil.year(date) + "").split("");
        StringBuilder s = new StringBuilder();
        for (String o : y) {
            String n = NUMBER.get(o);
            if (null == n) continue;
            s.append(n);
        }
        return s + "";
    }

    static {
        MONTH.put("01", "JAN");
        MONTH.put("02", "FEB");
        MONTH.put("03", "MAR");
        MONTH.put("04", "APR");
        MONTH.put("05", "MAY");
        MONTH.put("06", "JUN");
        MONTH.put("07", "JUL");
        MONTH.put("08", "AUG");
        MONTH.put("09", "SEP");
        MONTH.put("10", "OCT");
        MONTH.put("11", "NOV");
        MONTH.put("12", "DEC");
        MONTH.put("JAN", "01");
        MONTH.put("FEB", "02");
        MONTH.put("MAR", "03");
        MONTH.put("APR", "04");
        MONTH.put("MAY", "05");
        MONTH.put("JUN", "06");
        MONTH.put("JUL", "07");
        MONTH.put("AUG", "08");
        MONTH.put("SEP", "09");
        MONTH.put("OCT", "10");
        MONTH.put("NOV", "11");
        MONTH.put("DEC", "12");
        WEEK.put("1", "\u65e5");
        WEEK.put("2", "\u4e00");
        WEEK.put("3", "\u4e8c");
        WEEK.put("4", "\u4e09");
        WEEK.put("5", "\u56db");
        WEEK.put("6", "\u4e94");
        WEEK.put("7", "\u516d");
        NUMBER.put("0", "\u96f6");
        NUMBER.put("1", "\u4e00");
        NUMBER.put("2", "\u4e8c");
        NUMBER.put("3", "\u4e09");
        NUMBER.put("4", "\u56db");
        NUMBER.put("5", "\u4e94");
        NUMBER.put("6", "\u516d");
        NUMBER.put("7", "\u4e03");
        NUMBER.put("8", "\u516b");
        NUMBER.put("9", "\u4e5d");
    }
}

