/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.zip.ZipFile;

public class IOUtil {
    public static int BUFFER_SIZE = 20480;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, byte[] data, boolean append) throws IOException {
        BufferedOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file, true));
            out.write(data);
            out.flush();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(out);
            throw throwable;
        }
        IOUtil.closeQuietly(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] buffer = new byte[BUFFER_SIZE];
            int l = 0;
            while (-1 != (l = in.read(buffer))) {
                out.write(buffer, 0, l);
            }
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(out);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (null == closeable) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ZipFile zip) {
        if (null == zip) {
            return;
        }
        try {
            zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        if (null == socket) {
            return;
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Connection connection) {
        if (null == connection) {
            return;
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ResultSet rs) {
        if (null == rs) {
            return;
        }
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Statement stmt) {
        if (null == stmt) {
            return;
        }
        try {
            stmt.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

