/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import com.nlf.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class MathUtil {
    private MathUtil() {
    }

    public static byte[] toBit(byte value) {
        int l = 8;
        byte[] b = new byte[l];
        for (int i = 0; i < l; ++i) {
            b[i] = (byte)(value >> l - i - 1 & 1);
        }
        return b;
    }

    public static byte[] toBit(byte[] value) {
        int l = 8;
        int size = value.length;
        byte[] b = new byte[l * size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < l; ++j) {
                b[i * l + j] = (byte)(value[i] >> l - j - 1 & 1);
            }
        }
        return b;
    }

    public static byte[] toByte(int value, int size) {
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)(value >>> (b.length - i - 1) * 8 & 0xFF);
        }
        return b;
    }

    public static byte[] toByte(long value, int size) {
        byte[] b = new byte[size];
        for (int i = 0; i < size; ++i) {
            b[i] = (byte)(value >>> (b.length - i - 1) * 8 & 0xFFL);
        }
        return b;
    }

    public static int toInt(byte[] b) {
        int n = 0;
        for (int i = 0; i < b.length; ++i) {
            n += (b[i] & 0xFF) << (b.length - i - 1) * 8;
        }
        return n;
    }

    public static long toLong(byte[] b) {
        long n = 0L;
        for (int i = 0; i < b.length; ++i) {
            n += (long)((b[i] & 0xFF) << (b.length - i - 1) * 8);
        }
        return n;
    }

    public static byte[] merge(byte[] a, byte[] b) {
        int la = a.length;
        int lb = b.length;
        byte[] t = new byte[la + lb];
        System.arraycopy(a, 0, t, 0, la);
        System.arraycopy(b, 0, t, la, lb);
        return t;
    }

    public static byte[] merge(byte[] ... arrays) {
        byte[] t = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            for (byte[] b : arrays) {
                os.write(b);
            }
            os.flush();
            t = os.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtil.closeQuietly(os);
        }
        return t;
    }

    public static byte[] sub(byte[] src, int from, int to) {
        byte[] t = new byte[to - from + 1];
        System.arraycopy(src, from, t, 0, to - from + 1);
        return t;
    }
}

