/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao;

import com.nlf.App;
import com.nlf.dao.DaoType;
import com.nlf.dao.IDao;
import com.nlf.dao.connection.ConnectionFactory;
import com.nlf.dao.connection.IConnection;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.executer.AbstractDaoExecuter;
import com.nlf.dao.executer.IDaoExecuter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractDao
implements IDao {
    protected static final Map<String, Map<String, String>> EXECUTERS = new HashMap<String, Map<String, String>>();
    protected String alias;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public DaoType getType() {
        return DaoType.sql;
    }

    protected IConnection getConnection() {
        return ConnectionFactory.getConnection(this.alias);
    }

    protected IDaoExecuter getImpl(String dbType, String executerInterface) {
        Map<String, String> impls = EXECUTERS.get(dbType);
        if (null == impls) {
            impls = new HashMap<String, String>(2);
            EXECUTERS.put(dbType, impls);
        }
        if (!impls.containsKey(executerInterface)) {
            List<String> l = App.getImplements(executerInterface);
            for (String klass : l) {
                IDaoExecuter executer = (IDaoExecuter)App.getProxy().newInstance(klass);
                if (!executer.support(dbType)) continue;
                impls.put(executerInterface, klass);
                return executer;
            }
            impls.put(executerInterface, null);
        } else {
            String impl = impls.get(executerInterface);
            if (null != impl) {
                return (IDaoExecuter)App.getProxy().newInstance(impl);
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.executer.not_found", dbType, executerInterface));
    }

    protected IDaoExecuter getExecuter(String executerInterface) {
        IConnection connection = this.getConnection();
        String dbType = connection.getDbSetting().getDbType();
        AbstractDaoExecuter executer = (AbstractDaoExecuter)this.getImpl(dbType, executerInterface);
        executer.setConnection(connection);
        return executer;
    }
}

