/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.Bean;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ISqlInserter;
import com.nlf.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ASqlInserter
extends AbstractSqlExecuter
implements ISqlInserter {
    protected List<Condition> columns = new ArrayList<Condition>();

    public ISqlInserter table(String tables) {
        this.tables.add(tables);
        return this;
    }

    public ISqlInserter tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    public String buildSql() {
        Condition r;
        int i;
        StringBuilder s = new StringBuilder();
        s.append("INSERT INTO ");
        s.append(StringUtil.join(this.tables, ","));
        s.append("(");
        int l = this.columns.size();
        for (i = 0; i < l; ++i) {
            s.append(i < 1 ? "" : ",");
            r = this.columns.get(i);
            s.append(r.getColumn());
        }
        s.append(") VALUES(");
        int j = this.columns.size();
        for (i = 0; i < j; ++i) {
            s.append(i < 1 ? "" : ",");
            r = this.columns.get(i);
            this.params.add(r.getValue());
            s.append(r.getStart());
            s.append(r.getPlaceholder());
            s.append(r.getEnd());
        }
        s.append(")");
        return s.toString();
    }

    public int insert() {
        return this.executeUpdate();
    }

    public Bean insertAndGetGenerated() {
        return this.executeUpdateAndGetGenerated();
    }

    public ISqlInserter set(String column, Object value) {
        Condition cond = new Condition();
        cond.setColumn(column);
        cond.setValue(value);
        cond.setStart("");
        this.columns.add(cond);
        return this;
    }

    public ISqlInserter set(Bean bean) {
        for (String key : bean.keySet()) {
            this.set(key, bean.get(key));
        }
        return this;
    }

    public ISqlInserter setIf(String column, Object value, boolean condition) {
        if (condition) {
            this.set(column, value);
        }
        return this;
    }

    public ISqlInserter setIf(Bean bean, boolean condition) {
        if (condition) {
            this.set(bean);
        }
        return this;
    }
}

