/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.common;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.core.IRequest;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.AbstractSqlExecuter;
import com.nlf.extend.dao.sql.Condition;
import com.nlf.extend.dao.sql.ConditionType;
import com.nlf.extend.dao.sql.ISqlSelecter;
import com.nlf.log.Logger;
import com.nlf.util.StringUtil;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASqlSelecter
extends AbstractSqlExecuter
implements ISqlSelecter {
    @Override
    public ISqlSelecter table(String tables) {
        this.tables.add(tables);
        return this;
    }

    @Override
    public ISqlSelecter tableIf(String tables, boolean condition) {
        if (condition) {
            this.table(tables);
        }
        return this;
    }

    @Override
    public ISqlSelecter column(String columns) {
        this.columns.add(columns);
        return this;
    }

    @Override
    public ISqlSelecter columnIf(String columns, boolean condition) {
        if (condition) {
            this.column(columns);
        }
        return this;
    }

    @Override
    public ISqlSelecter where(String sql) {
        super.where(sql);
        return this;
    }

    @Override
    public ISqlSelecter where(String columnOrSql, Object valueOrBean) {
        super.where(columnOrSql, valueOrBean);
        return this;
    }

    @Override
    public ISqlSelecter whereIf(String sql, boolean condition) {
        if (condition) {
            this.where(sql);
        }
        return this;
    }

    @Override
    public ISqlSelecter whereIf(String columnOrSql, Object valueOrBean, boolean condition) {
        if (condition) {
            this.where(columnOrSql, valueOrBean);
        }
        return this;
    }

    @Override
    public ISqlSelecter whereIn(String column, Object ... values) {
        super.whereIn(column, values);
        return this;
    }

    @Override
    public ISqlSelecter whereNotIn(String column, Object ... values) {
        super.whereNotIn(column, values);
        return this;
    }

    @Override
    public ISqlSelecter whereNotEqual(String column, Object value) {
        super.whereNotEqual(column, value);
        return this;
    }

    @Override
    public ISqlSelecter having(String sql) {
        this.havings.add(this.buildPureSqlCondition(sql));
        return this;
    }

    @Override
    public ISqlSelecter having(String columnOrSql, Object valueOrBean) {
        Condition cond = new Condition();
        cond.setColumn(columnOrSql);
        if (null == valueOrBean) {
            cond.setStart(" IS");
            cond.setPlaceholder(" NULL");
            cond.setType(ConditionType.pure_sql);
        } else if (columnOrSql.contains(":") && valueOrBean instanceof Bean) {
            cond.setStart("");
            cond.setPlaceholder("");
            cond.setEnd("");
            cond.setValue(valueOrBean);
            cond.setType(ConditionType.multi_params);
        } else {
            cond.setValue(valueOrBean);
        }
        this.havings.add(cond);
        return this;
    }

    @Override
    public ISqlSelecter havingIf(String sql, boolean condition) {
        if (condition) {
            this.having(sql);
        }
        return this;
    }

    @Override
    public ISqlSelecter havingIf(String columnOrSql, Object valueOrBean, boolean condition) {
        if (condition) {
            this.having(columnOrSql, valueOrBean);
        }
        return this;
    }

    @Override
    public ISqlSelecter groupBy(String columns) {
        this.groupBys.add(columns);
        return this;
    }

    @Override
    public ISqlSelecter groupByIf(String columns, boolean condition) {
        if (condition) {
            this.groupBy(columns);
        }
        return this;
    }

    protected ISqlSelecter sorts(String columns, String order) {
        String right = columns;
        int index = right.indexOf(",");
        StringBuilder col = new StringBuilder();
        int bracketOpen = 0;
        int bracketClose = 0;
        while (index > -1) {
            String left = right.substring(0, index);
            col.append(left);
            if ((bracketOpen += left.length() - left.replace("(", "").length()) > (bracketClose += left.length() - left.replace(")", "").length())) {
                col.append(",");
            } else {
                if (col.length() > 0) {
                    this.sorts.add(col + " " + order);
                }
                col.setLength(0);
                bracketOpen = 0;
                bracketClose = 0;
            }
            right = right.substring(index + 1);
            index = right.indexOf(",");
        }
        if (right.length() > 0) {
            col.append(right);
            this.sorts.add(col + " " + order);
        }
        return this;
    }

    @Override
    public ISqlSelecter asc(String columns) {
        return this.sorts(columns, "ASC");
    }

    @Override
    public ISqlSelecter ascIf(String columns, boolean condition) {
        if (condition) {
            this.asc(columns);
        }
        return this;
    }

    @Override
    public ISqlSelecter desc(String columns) {
        return this.sorts(columns, "DESC");
    }

    @Override
    public ISqlSelecter descIf(String columns, boolean condition) {
        if (condition) {
            this.desc(columns);
        }
        return this;
    }

    @Override
    public String buildSql() {
        return this.buildSql(false);
    }

    public String buildSql(boolean count) {
        int i;
        StringBuilder s = new StringBuilder();
        s.append("SELECT ");
        if (count) {
            s.append("COUNT(1) NLFCOUNT_");
        } else {
            s.append(this.columns.size() < 1 ? "*" : StringUtil.join(this.columns, ","));
        }
        s.append(" FROM ");
        s.append(StringUtil.join(this.tables, ","));
        s.append(this.buildSqlWhere());
        int j = this.groupBys.size();
        for (i = 0; i < j; ++i) {
            s.append(" ");
            s.append(i < 1 ? "GROUP BY " : ",");
            s.append((String)this.groupBys.get(i));
        }
        int l = this.havings.size();
        for (i = 0; i < l; ++i) {
            s.append(" ");
            s.append(i < 1 ? "HAVING" : "AND");
            s.append(" ");
            s.append(this.buildSqlParams((Condition)this.havings.get(i)));
        }
        if (!count) {
            j = this.sorts.size();
            for (i = 0; i < j; ++i) {
                s.append(" ");
                s.append(i < 1 ? "ORDER BY " : ",");
                s.append((String)this.sorts.get(i));
            }
        }
        return s.toString();
    }

    @Override
    public List<Bean> query() {
        this.params.clear();
        this.sql = this.buildSql();
        Logger.getLog().debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public List<Bean> top(int count) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public Bean topOne() {
        List<Bean> l = this.top(1);
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public Bean one() {
        List<Bean> l = this.query();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        return l.get(0);
    }

    @Override
    public int count() {
        this.params.clear();
        this.sql = this.buildSql(true);
        Logger.getLog().debug(this.buildLog());
        List<Bean> l = this.queryList();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        throw new DaoException(App.getProperty("nlf.exception.dao.operation_not_support", new Object[0]));
    }

    @Override
    public PageData paging() {
        IRequest r = App.getRequest();
        return this.page(r.getPageNumber(), r.getPageSize());
    }

    @Override
    public Iterator<Bean> iterator() {
        this.params.clear();
        this.sql = this.buildSql();
        Logger.getLog().debug(this.buildLog());
        return this.queryIterator();
    }
}

