/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.dao.sql.dbType.sqlserver;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.paging.PageData;
import com.nlf.extend.dao.sql.dbType.common.ASqlTemplate;
import com.nlf.log.Logger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlserverTemplate
extends ASqlTemplate {
    @Override
    public boolean support(String dbType) {
        return "sqlserver".equalsIgnoreCase(dbType);
    }

    @Override
    public List<Bean> top(int count) {
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + count + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        return this.queryList();
    }

    @Override
    public int count() {
        this.params.clear();
        String sql = this.buildSql();
        sql = sql.replace("\r", " ").replace("\n", " ");
        String upperSql = sql.toUpperCase();
        int orderIndex = upperSql.indexOf(" ORDER ");
        if (orderIndex > -1) {
            sql = sql.substring(0, orderIndex);
        }
        sql = "SELECT COUNT(*) NLFCOUNT_ FROM (" + sql + ") NLFTABLE_";
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        List<Bean> l = this.queryList();
        if (l.size() < 1) {
            throw new DaoException(App.getProperty("nlf.exception.dao.select.one.not_found", new Object[0]));
        }
        Bean o = l.get(0);
        return o.getInt("NLFCOUNT_", 0);
    }

    @Override
    public PageData page(int pageNumber, int pageSize) {
        PageData d = new PageData();
        d.setPageSize(pageSize);
        d.setPageNumber(pageNumber);
        d.setRecordCount(this.count());
        if (d.getPageNumber() > d.getPageCount()) {
            return d;
        }
        this.params.clear();
        String sql = this.buildSql();
        sql = "SELECT TOP " + d.getPageNumber() * d.getPageSize() + sql.replaceFirst("SELECT", "");
        this.sql = sql = this.buildParams(sql, this.param);
        Logger.getLog().debug(this.buildLog());
        List<Bean> l = this.queryList((d.getPageNumber() - 1) * d.getPageSize());
        d.setData(l);
        return d;
    }
}

