/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.log.impl;

import com.nlf.App;
import com.nlf.log.AbstractLog;
import com.nlf.util.DateUtil;

public class DefaultLog
extends AbstractLog {
    public static final String KLASS = DefaultLog.class.getName();

    public DefaultLog(String name) {
        super(name);
    }

    private StackTraceElement findStackTrace() {
        StackTraceElement[] sts;
        int index = 0;
        for (StackTraceElement st : sts = Thread.currentThread().getStackTrace()) {
            if (KLASS.equals(st.getClassName())) {
                index += 2;
                break;
            }
            ++index;
        }
        return sts[index];
    }

    public void debug(String msg) {
        System.out.println(App.getProperty("nlf.log.default.debug", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
    }

    public void debug(String msg, Throwable e) {
        System.out.println(App.getProperty("nlf.log.default.debug", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
        e.printStackTrace();
    }

    public void info(String msg) {
        System.out.println(App.getProperty("nlf.log.default.info", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
    }

    public void info(String msg, Throwable e) {
        System.out.println(App.getProperty("nlf.log.default.info", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
        e.printStackTrace();
    }

    public void warn(String msg) {
        System.out.println(App.getProperty("nlf.log.default.warn", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
    }

    public void warn(String msg, Throwable e) {
        System.out.println(App.getProperty("nlf.log.default.warn", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
        e.printStackTrace();
    }

    public void error(String msg) {
        System.err.println(App.getProperty("nlf.log.default.error", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
    }

    public void error(String msg, Throwable e) {
        System.err.println(App.getProperty("nlf.log.default.error", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
        e.printStackTrace();
    }

    public void trace(String msg) {
        System.out.println(App.getProperty("nlf.log.default.trace", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
    }

    public void trace(String msg, Throwable e) {
        System.out.println(App.getProperty("nlf.log.default.trace", DateUtil.ymdhms(DateUtil.now()), this.name, this.findStackTrace(), msg));
        e.printStackTrace();
    }

    public boolean isDebugEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    public boolean isTraceEnabled() {
        return true;
    }
}

