/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.serialize;

import com.nlf.Bean;
import com.nlf.serialize.IParser;
import com.nlf.serialize.node.INode;
import com.nlf.serialize.node.impl.NodeBool;
import com.nlf.serialize.node.impl.NodeList;
import com.nlf.serialize.node.impl.NodeMap;
import com.nlf.serialize.node.impl.NodeNumber;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParser
implements IParser {
    public abstract INode parseAll(String var1);

    @Override
    public <T> T parse(String s) {
        return this.parse(this.parseAll(s));
    }

    protected Object wrapAttributes(INode n, Object value) {
        if (n.getAttributes().size() > 0) {
            Bean o = new Bean();
            if (null != value) {
                if (value instanceof Bean) {
                    Bean map = (Bean)value;
                    for (String key : map.keySet()) {
                        o.set(key, map.get(key));
                    }
                } else {
                    o.set("value", value);
                }
            }
            for (Map.Entry<String, String> en : n.getAttributes().entrySet()) {
                o.set("@" + en.getKey(), en.getValue());
            }
            return o;
        }
        return value;
    }

    protected Bean genMap(NodeMap nm) {
        Bean bean = new Bean();
        for (String key : nm.keySet()) {
            INode n = nm.get(key);
            if (null == n) {
                bean.set(key, null);
                continue;
            }
            switch (n.getType()) {
                case STRING: {
                    bean.set(key, this.wrapAttributes(n, n.toString()));
                    break;
                }
                case NUMBER: {
                    bean.set(key, this.wrapAttributes(n, ((NodeNumber)n).getValue()));
                    break;
                }
                case BOOL: {
                    bean.set(key, this.wrapAttributes(n, ((NodeBool)n).value()));
                    break;
                }
                case MAP: {
                    bean.set(key, this.wrapAttributes(n, this.genMap((NodeMap)n)));
                    break;
                }
                case LIST: {
                    bean.set(key, this.wrapAttributes(n, this.genList((NodeList)n)));
                    break;
                }
            }
        }
        return bean;
    }

    protected List<Object> genList(NodeList nl) {
        ArrayList<Object> l = new ArrayList<Object>();
        int j = nl.size();
        block7: for (int i = 0; i < j; ++i) {
            INode n = nl.get(i);
            if (null == n) {
                l.add(null);
                continue;
            }
            switch (n.getType()) {
                case STRING: {
                    l.add(this.wrapAttributes(n, n.toString()));
                    continue block7;
                }
                case NUMBER: {
                    l.add(this.wrapAttributes(n, ((NodeNumber)n).getValue()));
                    continue block7;
                }
                case BOOL: {
                    l.add(this.wrapAttributes(n, ((NodeBool)n).value()));
                    continue block7;
                }
                case MAP: {
                    l.add(this.wrapAttributes(n, this.genMap((NodeMap)n)));
                    continue block7;
                }
                case LIST: {
                    l.add(this.wrapAttributes(n, this.genList((NodeList)n)));
                    continue block7;
                }
            }
        }
        return l;
    }

    protected <T> T parse(INode n) {
        if (null == n) {
            return null;
        }
        switch (n.getType()) {
            case STRING: {
                return (T)this.wrapAttributes(n, n.toString());
            }
            case NUMBER: {
                return (T)this.wrapAttributes(n, ((NodeNumber)n).getValue());
            }
            case BOOL: {
                return (T)this.wrapAttributes(n, ((NodeBool)n).value());
            }
            case MAP: {
                return (T)this.wrapAttributes(n, this.genMap((NodeMap)n));
            }
            case LIST: {
                return (T)this.wrapAttributes(n, this.genList((NodeList)n));
            }
        }
        return null;
    }
}

