/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.web;

import com.nlf.core.ScannerFactory;
import com.nlf.extend.web.impl.DefaultServlet;
import com.nlf.resource.klass.filter.JarFileFilter;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;

public class WebApp {
    public static String contextPath = "";
    public static String realPath = "";
    public static String libPath = "";
    public static ServletContext context;
    public static final Set<String> SERVLET_SUFFIXS;

    protected WebApp() {
    }

    public static void init(ServletContext servletContext) {
        File[] jars;
        context = servletContext;
        realPath = servletContext.getRealPath("");
        contextPath = servletContext.getContextPath();
        libPath = servletContext.getRealPath("/WEB-INF/lib");
        System.out.println("WebApp.contextPath = " + contextPath);
        System.out.println("WebApp.realPath    = " + realPath);
        System.out.println("WebApp.libPath     = " + libPath);
        String servletClass = DefaultServlet.class.getName();
        for (Map.Entry entry : servletContext.getServletRegistrations().entrySet()) {
            String key = (String)entry.getKey();
            ServletRegistration servlet = (ServletRegistration)entry.getValue();
            String className = servlet.getClassName();
            if (null == className) {
                className = servletClass;
                servletContext.addServlet(key, className);
            }
            if (!servletClass.equals(className)) continue;
            for (String mapping : servlet.getMappings()) {
                if (!mapping.startsWith("*.")) continue;
                String suffix = mapping.substring(1);
                SERVLET_SUFFIXS.add(suffix);
            }
        }
        String[] jarPaths = new String[]{};
        File libDir = new File(libPath);
        if (libDir.exists() && null != (jars = libDir.listFiles(new JarFileFilter()))) {
            int jarCount = jars.length;
            jarPaths = new String[jarCount];
            for (int i = 0; i < jarCount; ++i) {
                jarPaths[i] = jars[i].getAbsolutePath();
            }
        }
        ScannerFactory.getScanner().setCaller(servletContext.getRealPath("/WEB-INF/classes")).addAbsolutePath(libPath).addAbsolutePath(jarPaths);
        ScannerFactory.startScan();
    }

    static {
        SERVLET_SUFFIXS = new HashSet<String>();
    }
}

