/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.util;

import com.nlf.util.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamCache {
    private ByteArrayOutputStream cachedStream;

    public InputStreamCache(InputStream inputStream) throws IOException {
        int l;
        if (null == inputStream) {
            return;
        }
        this.cachedStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
        while (-1 != (l = inputStream.read(buffer))) {
            this.cachedStream.write(buffer, 0, l);
        }
        this.cachedStream.flush();
    }

    public InputStream getInputStream() {
        if (null == this.cachedStream) {
            return null;
        }
        return new ByteArrayInputStream(this.cachedStream.toByteArray());
    }
}

