/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.bytecode;

import com.nlf.bytecode.Method;
import com.nlf.bytecode.constant.AbstractConstant;
import com.nlf.bytecode.constant.ClassConstant;
import com.nlf.bytecode.constant.DefaultConstant;
import com.nlf.bytecode.constant.FieldConstant;
import com.nlf.bytecode.constant.IConstant;
import com.nlf.bytecode.constant.InvokeDynamicConstant;
import com.nlf.bytecode.constant.MethodConstant;
import com.nlf.bytecode.constant.MethodHandleConstant;
import com.nlf.bytecode.constant.MethodTypeConstant;
import com.nlf.bytecode.constant.NameAndTypeConstant;
import com.nlf.bytecode.constant.UTFConstant;
import com.nlf.util.IOUtil;
import com.nlf.util.MathUtil;
import com.nlf.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Klass {
    private byte[] byteCodes;
    private int minorVersion;
    private int majorVersion;
    private int access;
    private String superClass;
    private String name;
    private List<IConstant> constants = new ArrayList<IConstant>();
    private Set<String> interfaces = new LinkedHashSet<String>();
    private List<Method> methods = new ArrayList<Method>();

    public Klass(byte[] byteCodes) throws IOException {
        this.byteCodes = byteCodes;
        this.decode();
    }

    protected IConstant getConstant(int index) {
        return this.constants.get(index);
    }

    public Set<String> getInterfaces() {
        return this.interfaces;
    }

    public String getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.access);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.access);
    }

    public int getAccess() {
        return this.access;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public List<Method> getMethods() {
        return this.methods;
    }

    protected void decodeConstants(DataInputStream in) throws IOException {
        byte[] b = new byte[2];
        in.read(b);
        int count = MathUtil.toInt(b);
        this.constants.add(null);
        for (int i = 1; i < count; ++i) {
            byte tag = in.readByte();
            AbstractConstant c = new DefaultConstant();
            switch (tag) {
                case 7: {
                    b = new byte[2];
                    in.read(b);
                    c = new ClassConstant(b, MathUtil.toInt(b));
                    break;
                }
                case 18: {
                    b = new byte[4];
                    in.read(b);
                    c = new InvokeDynamicConstant(MathUtil.toInt(new byte[]{b[0], b[1]}), MathUtil.toInt(new byte[]{b[2], b[3]}));
                    break;
                }
                case 15: {
                    b = new byte[3];
                    in.read(b);
                    c = new MethodHandleConstant(b[0], MathUtil.toInt(new byte[]{b[1], b[2]}));
                    break;
                }
                case 16: {
                    b = new byte[2];
                    in.read(b);
                    c = new MethodTypeConstant(MathUtil.toInt(b));
                    break;
                }
                case 8: {
                    b = new byte[2];
                    in.read(b);
                    break;
                }
                case 9: {
                    b = new byte[4];
                    in.read(b);
                    c = new FieldConstant(b, MathUtil.toInt(MathUtil.sub(b, 0, 1)), MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                    break;
                }
                case 10: {
                    b = new byte[4];
                    in.read(b);
                    c = new MethodConstant(b, MathUtil.toInt(MathUtil.sub(b, 0, 1)), MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                    break;
                }
                case 12: {
                    b = new byte[4];
                    in.read(b);
                    c = new NameAndTypeConstant(b, MathUtil.toInt(MathUtil.sub(b, 0, 1)), MathUtil.toInt(MathUtil.sub(b, 2, 3)));
                    break;
                }
                case 3: 
                case 4: 
                case 11: {
                    b = new byte[4];
                    in.read(b);
                    c.setData(b);
                    break;
                }
                case 1: {
                    b = new byte[2];
                    in.read(b);
                    int length = MathUtil.toInt(b);
                    b = new byte[length];
                    in.read(b);
                    c = new UTFConstant(b, new String(b, "utf-8"));
                    break;
                }
                case 5: 
                case 6: {
                    b = new byte[8];
                    in.read(b);
                    c.setData(b);
                    break;
                }
            }
            c.setIndex(i);
            c.setType(tag);
            this.constants.add(c);
            if (5 != c.getType() && 6 != c.getType()) continue;
            this.constants.add(null);
            ++i;
        }
    }

    protected String guessRet(byte[] data) {
        String ret = null;
        block20: for (int k = data.length - 1; k > -1; --k) {
            switch (data[k] & 0xFF) {
                case 172: {
                    ret = "I";
                    break block20;
                }
                case 173: {
                    ret = "J";
                    break block20;
                }
                case 174: {
                    ret = "F";
                    break block20;
                }
                case 175: {
                    ret = "D";
                    break block20;
                }
                case 177: {
                    ret = "V";
                    break block20;
                }
                case 176: {
                    for (int x = k - 1; x > -1; --x) {
                        int p = data[x] & 0xFF;
                        try {
                            IConstant c = this.getConstant(p);
                            switch (c.getType()) {
                                case 3: {
                                    ret = "I";
                                    break block20;
                                }
                                case 5: {
                                    ret = "J";
                                    break block20;
                                }
                                case 4: {
                                    ret = "F";
                                    break block20;
                                }
                                case 6: {
                                    ret = "D";
                                    break block20;
                                }
                                case 8: {
                                    ret = "Ljava/lang/String";
                                    break block20;
                                }
                                case 7: {
                                    String retType;
                                    ret = retType = "L" + this.getConstant(c.toClassConstant().getNameIndex()).toUTFConstant().getContent();
                                    break block20;
                                }
                                case 9: {
                                    String retType = this.getConstant(this.getConstant(c.toFieldConstant().getNameAndTypeIndex()).toNameAndTypeConstant().getDescriptorIndex()).toUTFConstant().getContent();
                                    if (retType.contains(";")) {
                                        retType = retType.substring(0, retType.indexOf(";"));
                                    }
                                    ret = retType;
                                    break block20;
                                }
                                case 10: {
                                    String methodName;
                                    String retType = this.getConstant(this.getConstant(c.toMethodConstant().getNameAndTypeIndex()).toNameAndTypeConstant().getDescriptorIndex()).toUTFConstant().getContent();
                                    if (retType.contains(")")) {
                                        retType = retType.substring(retType.lastIndexOf(")") + 1);
                                    }
                                    if (retType.contains(";")) {
                                        retType = retType.substring(0, retType.indexOf(";"));
                                    }
                                    if ("V".equals(retType) && "<init>".equals(methodName = this.getConstant(this.getConstant(c.toMethodConstant().getNameAndTypeIndex()).toNameAndTypeConstant().getNameIndex()).toUTFConstant().getContent())) {
                                        retType = "L" + this.getConstant(this.getConstant(c.toMethodConstant().getClassIndex()).toClassConstant().getNameIndex()).toUTFConstant().getContent();
                                    }
                                    ret = retType;
                                    break block20;
                                }
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    break block20;
                }
                default: {
                    continue block20;
                }
            }
        }
        return ret;
    }

    protected void decodeMethod(DataInputStream in) throws IOException {
        Method f = new Method(this);
        byte[] b = new byte[2];
        in.read(b);
        f.setAccess(MathUtil.toInt(b));
        in.read(b);
        f.setNameIndex(MathUtil.toInt(b));
        in.read(b);
        f.setDescriptorIndex(MathUtil.toInt(b));
        in.read(b);
        int attributeCount = MathUtil.toInt(b);
        String methodName = f.getName();
        for (int j = 0; j < attributeCount; ++j) {
            b = new byte[2];
            in.read(b);
            String attrName = this.getConstant(MathUtil.toInt(b)).toUTFConstant().getContent();
            b = new byte[4];
            in.read(b);
            int length = MathUtil.toInt(b);
            if ("<init>".equals(methodName) || "<clinit>".equals(methodName) || methodName.startsWith("$SWITCH_TABLE$") || !"Code".equals(attrName)) {
                in.skip(length);
                continue;
            }
            b = new byte[length];
            in.read(b);
            length = MathUtil.toInt(MathUtil.sub(b, 4, 7));
            f.setRetMaybe(this.guessRet(MathUtil.sub(b, 8, 8 + length - 1)));
        }
        this.methods.add(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode() throws IOException {
        ByteArrayInputStream stream = null;
        DataInputStream in = null;
        try {
            stream = new ByteArrayInputStream(this.byteCodes);
            in = new DataInputStream(stream);
            in.skip(4L);
            byte[] b = new byte[2];
            in.read(b);
            this.minorVersion = MathUtil.toInt(b);
            b = new byte[2];
            in.read(b);
            this.majorVersion = MathUtil.toInt(b);
            this.decodeConstants(in);
            b = new byte[2];
            in.read(b);
            this.access = MathUtil.toInt(b);
            b = new byte[2];
            in.read(b);
            this.name = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
            this.name = this.name.replace("/", ".");
            b = new byte[2];
            in.read(b);
            this.superClass = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
            this.superClass = this.superClass.replace("/", ".");
            b = new byte[2];
            in.read(b);
            int interfaceCount = MathUtil.toInt(b);
            for (int i = 0; i < interfaceCount; ++i) {
                b = new byte[2];
                in.read(b);
                String interfaceClass = this.getConstant(this.getConstant(MathUtil.toInt(b)).toClassConstant().getNameIndex()).toUTFConstant().getContent();
                interfaceClass = interfaceClass.replace("/", ".");
                this.interfaces.add(interfaceClass);
            }
            in.read(b);
            int fieldCount = MathUtil.toInt(b);
            for (int i = 0; i < fieldCount; ++i) {
                b = new byte[2];
                in.skip(6L);
                in.read(b);
                int attributeCount = MathUtil.toInt(b);
                for (int j = 0; j < attributeCount; ++j) {
                    in.skip(2L);
                    b = new byte[4];
                    in.read(b);
                    in.skip(MathUtil.toInt(b));
                }
            }
            b = new byte[2];
            in.read(b);
            int methodCount = MathUtil.toInt(b);
            for (int i = 0; i < methodCount; ++i) {
                this.decodeMethod(in);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(stream);
            throw throwable;
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(stream);
    }

    public String toString() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.access + "");
        l.add(this.isAbstract() ? "abstract" : "");
        l.add(this.isInterface() ? "interface" : "class");
        l.add(this.name);
        l.add("extends");
        l.add(this.superClass);
        l.add("implements");
        l.add(StringUtil.join(this.interfaces, ","));
        return StringUtil.join(l, " ");
    }
}

