/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.core.impl;

import com.nlf.App;
import com.nlf.core.IValidator;
import com.nlf.exception.ValidateException;
import com.nlf.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultValidator
implements IValidator {
    public static final String MSG_OR = "nlf.exception.validate.or";
    public static final String MSG_PREFIX = "nlf.exception.validate.";
    public static final String CONTAINS_TAG_PREFIX = "[";
    public static final String CONTAINS_TAG_SUFFIX = "]";
    public static final Map<String, String> REG = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("number", "^[0-9]*$");
            this.put("letter", "^[A-Za-z]+$");
            this.put("integer", "^-?\\d+$");
            this.put("letter_upper", "^[A-Z]+$");
            this.put("letter_lower", "^[a-z]+$");
            this.put("integer_positive", "^[1-9]\\d*$");
            this.put("integer_negtive", "^-[1-9]\\d*$");
            this.put("id_card", "^\\d{15}|^\\d{17}([0-9]|X|x)$");
            this.put("decimal_positive", "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$");
            this.put("decimal_negtive", "^-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*)$");
            this.put("decimal", "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$");
            this.put("email", "^\\w+([-+\\.]\\w+)*@\\w+([-\\.]\\w+)*\\.\\w+([-\\.]\\w+)*$");
            this.put("mobile", "^((13[0-9])|(14[0-9])|(15[^4,\\D])|(17[0-9])|(18[0-9]))\\d{8}$");
        }
    };

    protected void validateEmpty(String name, String value, String rule) throws ValidateException {
        if (null != value && value.length() > 0) {
            throw new ValidateException(App.getProperty("nlf.exception.validate.empty", name));
        }
    }

    protected void validateNotEmpty(String name, String value, String rule) throws ValidateException {
        if (null == value || value.length() < 1) {
            throw new ValidateException(App.getProperty("nlf.exception.validate.not_empty", name));
        }
    }

    protected void validateReg(String name, String value, String rule) throws ValidateException {
        this.validateNotEmpty(name, value, rule);
        Pattern p = Pattern.compile(REG.get(rule));
        Matcher m = p.matcher(value);
        if (!m.matches()) {
            throw new ValidateException(App.getProperty(MSG_PREFIX + rule, name));
        }
    }

    protected void validateExpression(String name, String value, String rule, String op, String ov) throws ValidateException {
        Pattern p;
        Matcher m;
        this.validateNotEmpty(name, value, rule);
        if ("is".equals(op) ? !value.equals(ov) : ("not".equals(op) ? value.equals(ov) : ("in".equals(op) ? !ov.contains(value) : ("not_in".equals(op) ? ov.contains(value) : ("contains".equals(op) ? !value.contains(ov) : ("not_contains".equals(op) ? value.contains(ov) : ("min_length".equals(op) ? value.length() < Integer.parseInt(ov) : ("max_length".equals(op) ? value.length() > Integer.parseInt(ov) : ("fix_length".equals(op) ? value.length() != Integer.parseInt(ov) : "regex".equals(op) && !(m = (p = Pattern.compile(ov)).matcher(value)).matches()))))))))) {
            throw new ValidateException(App.getProperty(MSG_PREFIX + op, name, ov));
        }
    }

    protected void validateSingle(String name, String value, String rule) throws ValidateException {
        if ("empty".equals(rule)) {
            this.validateEmpty(name, value, rule);
        } else if ("not_empty".equals(rule)) {
            this.validateNotEmpty(name, value, rule);
        } else if (REG.containsKey(rule)) {
            this.validateReg(name, value, rule);
        } else if (rule.contains(CONTAINS_TAG_PREFIX)) {
            int start = rule.indexOf(CONTAINS_TAG_PREFIX);
            String op = rule.substring(0, start);
            String ov = rule.substring(start + 1, rule.lastIndexOf(CONTAINS_TAG_SUFFIX));
            this.validateExpression(name, value, rule, op, ov);
        }
    }

    public void validate(String name, String value, String rules) throws ValidateException {
        if (rules.contains("||")) {
            String[] ors = rules.split("||".replace("|", "\\|"), -1);
            ArrayList<String> messages = new ArrayList<String>(ors.length);
            for (String or : ors) {
                try {
                    this.validate(name, value, or);
                    return;
                }
                catch (ValidateException e) {
                    String message = e.getMessage();
                    if (null == message || message.length() <= 0) continue;
                    messages.add(message);
                }
            }
            throw new ValidateException(StringUtil.join(messages, App.getProperty(MSG_OR, new Object[0])));
        }
        if (rules.contains("&&")) {
            String[] ands;
            for (String and : ands = rules.split("&&", -1)) {
                this.validate(name, value, and);
            }
        } else {
            this.validateSingle(name, value, rules);
        }
    }
}

