/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.dao.connection;

import com.nlf.App;
import com.nlf.dao.connection.IConnection;
import com.nlf.dao.connection.IConnectionProvider;
import com.nlf.dao.exception.DaoException;
import com.nlf.dao.setting.DbSettingFactory;
import com.nlf.dao.setting.IDbSetting;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectionFactory {
    protected static final Map<String, IConnectionProvider> POOL = new HashMap<String, IConnectionProvider>();

    protected ConnectionFactory() {
    }

    public static void closeAll() {
        Map connections = (Map)App.get("NLF_CONNECTION");
        if (null != connections) {
            for (IConnection connection : connections.values()) {
                connection.close();
            }
        }
    }

    public static void close(String alias) {
        IConnection conn;
        Map connections = (Map)App.get("NLF_CONNECTION");
        if (null != connections && null != (conn = (IConnection)connections.get(alias)) && !conn.isClosed()) {
            conn.close();
        }
    }

    public static IConnection getConnection(String alias) {
        IConnection connection;
        HashMap<String, IConnection> connections = (HashMap<String, IConnection>)App.get("NLF_CONNECTION");
        if (null == connections) {
            connections = new HashMap<String, IConnection>(2);
            App.set("NLF_CONNECTION", connections);
        }
        if (null != (connection = (IConnection)connections.get(alias)) && !connection.isClosed()) {
            return connection;
        }
        IDbSetting setting = DbSettingFactory.getSetting(alias);
        String type = setting.getType();
        if (!POOL.containsKey(alias)) {
            List<String> impls = App.getImplements(IConnectionProvider.class);
            for (String impl : impls) {
                IConnectionProvider p = (IConnectionProvider)App.getProxy().newInstance(impl);
                if (!p.support(type)) continue;
                POOL.put(alias, p);
                p.setDbSetting(setting);
                IConnection conn = p.getConnection();
                connections.put(alias, conn);
                return conn;
            }
            POOL.put(alias, null);
        } else {
            IConnectionProvider p = POOL.get(alias);
            if (null != p) {
                IConnection conn = p.getConnection();
                connections.put(alias, conn);
                return conn;
            }
        }
        throw new DaoException(App.getProperty("nlf.exception.dao.connection.provider.not_found", type));
    }

    public static IConnection getConnection() {
        return ConnectionFactory.getConnection(DbSettingFactory.getDefaultSetting().getAlias());
    }
}

