/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.web.impl;

import com.nlf.App;
import com.nlf.core.IRequest;
import com.nlf.core.UploadFile;
import com.nlf.exception.ValidateException;
import com.nlf.extend.web.IWebFileUploader;
import com.nlf.extend.web.IWebRequest;
import com.nlf.util.ByteArray;
import com.nlf.util.FileUtil;
import com.nlf.util.IOUtil;
import com.nlf.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWebFileUploader
implements IWebFileUploader {
    public static final String KEY_TAG = " name=\"";
    public static final String FILE_TAG = "filename=\"";
    public static final String BOUNDARY_TAG = "boundary=";
    public static final String MULTIPART_TAG = "multipart/form-data";
    protected FormItem formItem;

    protected byte[] getBoundary(String contentType) {
        if (null == contentType) {
            return null;
        }
        if (!contentType.contains(MULTIPART_TAG)) {
            return null;
        }
        if (!contentType.contains(BOUNDARY_TAG)) {
            return null;
        }
        return ("\r\n--" + StringUtil.right(contentType, BOUNDARY_TAG)).getBytes();
    }

    protected void append(byte[] boundary, ByteArray cache) throws IOException {
        int lb;
        if (null == this.formItem) {
            return;
        }
        int size = cache.size();
        if (size > (lb = boundary.length)) {
            int lr = size - lb;
            this.appendFile(cache.sub(0, lr).toArray());
            cache.removeHead(lr);
        }
    }

    protected void appendFile(byte[] data) throws IOException {
        if (null == this.formItem) {
            return;
        }
        File tempFile = this.formItem.getTempFile();
        if (null == tempFile) {
            UploadFile file = this.formItem.getFile();
            String fileName = file.getName();
            String suffix = file.getSuffix();
            if (fileName.contains(".")) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            StringBuilder prefix = new StringBuilder();
            prefix.append(fileName);
            while (prefix.length() < 2) {
                prefix.append("_");
            }
            prefix.append("_");
            if (suffix.length() > 0) {
                suffix = "." + suffix;
            }
            tempFile = File.createTempFile(prefix.toString(), suffix);
            this.formItem.setTempFile(tempFile);
        }
        IOUtil.writeFile(tempFile, data, true);
    }

    protected void parseItem(byte[] boundary, ByteArray cache, List<UploadFile> files) throws IOException {
        if (null == this.formItem) {
            int index = cache.indexOf(new byte[]{13, 10, 13, 10});
            while (index > -1) {
                String header = new String(cache.sub(0, index).toArray(), "utf-8");
                if (header.contains(FILE_TAG)) {
                    String fileName = StringUtil.between(header, FILE_TAG, "\"");
                    if (fileName.length() > 0) {
                        this.formItem = new FormItem();
                        UploadFile file = new UploadFile();
                        file.setName(fileName);
                        file.setSuffix(fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "");
                        if (header.contains(KEY_TAG)) {
                            String key = StringUtil.between(header, KEY_TAG, "\"");
                            file.setKey(key);
                        }
                        if (header.contains("Content-Type:")) {
                            file.setContentType(StringUtil.right(header, ":").trim());
                        }
                        this.formItem.setFile(file);
                    }
                } else if (header.contains(KEY_TAG)) {
                    this.formItem = new FormItem();
                    String key = StringUtil.between(header, KEY_TAG, "\"");
                    this.formItem.setKey(key);
                }
                cache.removeHead(index + 4);
                int endIndex = cache.indexOf(boundary);
                if (endIndex > -1) {
                    byte[] data = cache.sub(0, endIndex).toArray();
                    if (null != this.formItem) {
                        UploadFile file = this.formItem.getFile();
                        String key = this.formItem.getKey();
                        if (null != file) {
                            file.setBytes(data);
                            file.setType(0);
                            file.setSize(data.length);
                            files.add(file);
                        } else if (null != key) {
                            IRequest r = App.getRequest();
                            r.getParam().set(key, new String(data, "utf-8"));
                        }
                    }
                    this.formItem = null;
                    cache.removeHead(endIndex);
                }
                index = cache.indexOf(new byte[]{13, 10, 13, 10});
            }
            this.append(boundary, cache);
        } else {
            int endIndex = cache.indexOf(boundary);
            if (endIndex > -1) {
                this.appendFile(cache.sub(0, endIndex).toArray());
                File tempFile = this.formItem.getTempFile();
                if (null != this.formItem) {
                    UploadFile file = this.formItem.getFile();
                    String key = this.formItem.getKey();
                    if (null != file) {
                        file.setTempFile(tempFile);
                        file.setType(1);
                        file.setSize(tempFile.length());
                        files.add(file);
                    } else if (null != key) {
                        IRequest r = App.getRequest();
                        r.getParam().set(key, FileUtil.readAsText(tempFile));
                    }
                }
                this.formItem = null;
                cache.removeHead(endIndex);
            } else {
                this.append(boundary, cache);
            }
        }
    }

    @Override
    public List<UploadFile> getFiles() throws ValidateException {
        ArrayList<UploadFile> files = new ArrayList<UploadFile>();
        IWebRequest r = (IWebRequest)App.getRequest();
        byte[] boundary = this.getBoundary(r.getServletRequest().getContentType());
        if (null == boundary) {
            return files;
        }
        ByteArray cache = new ByteArray();
        byte[] buffer = new byte[IOUtil.BUFFER_SIZE];
        try {
            int l;
            InputStream reader = r.getInputStream();
            while (-1 != (l = reader.read(buffer))) {
                byte[] tmp = new byte[l];
                System.arraycopy(buffer, 0, tmp, 0, l);
                cache.append(tmp);
                this.parseItem(boundary, cache, files);
            }
            this.parseItem(boundary, cache, files);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return files;
    }

    private static final class FormItem {
        private String key;
        private File tempFile;
        private UploadFile file;

        private FormItem() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public File getTempFile() {
            return this.tempFile;
        }

        public void setTempFile(File tempFile) {
            this.tempFile = tempFile;
        }

        public UploadFile getFile() {
            return this.file;
        }

        public void setFile(UploadFile file) {
            this.file = file;
        }
    }
}

