/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.web.impl;

import com.nlf.App;
import com.nlf.Bean;
import com.nlf.extend.web.AbstractWebResponse;
import com.nlf.extend.web.IWebRequest;
import com.nlf.extend.web.view.PageView;
import com.nlf.extend.web.view.RedirectView;
import com.nlf.extend.web.view.StreamView;
import com.nlf.util.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DefaultWebResponse
extends AbstractWebResponse {
    public void send(Object o) throws IOException {
        if (null == o) {
            return;
        }
        if (o instanceof RedirectView) {
            this.sendRedirect((RedirectView)o);
        } else if (o instanceof PageView) {
            this.sendPage((PageView)o);
        } else if (o instanceof StreamView) {
            this.sendStream((StreamView)o);
        } else {
            super.send(o);
        }
    }

    public void sendString(String s) throws IOException {
        this.sendString(s, "text/plain");
    }

    public void sendString(String s, String contentType) throws IOException {
        this.servletResponse.setContentType(contentType + ";charset=" + "utf-8");
        this.servletResponse.setCharacterEncoding("utf-8");
        this.servletResponse.getWriter().write(s);
        this.servletResponse.getWriter().flush();
    }

    public void sendRedirect(RedirectView v) throws IOException {
        this.servletResponse.sendRedirect(v.getUri());
    }

    public void sendPage(PageView v) throws IOException {
        IWebRequest request = (IWebRequest)App.get("NLF_REQUEST");
        HttpServletRequest req = request.getServletRequest();
        Bean attrs = v.getAttributes();
        Bean param = request.getParam();
        for (String key : param.keySet()) {
            req.setAttribute(key, param.get(key));
        }
        for (String key : attrs.keySet()) {
            req.setAttribute(key, attrs.get(key));
        }
        String includePath = (String)req.getAttribute("javax.servlet.include.request_uri");
        try {
            if (null == includePath) {
                req.getRequestDispatcher(v.getUri()).forward((ServletRequest)req, (ServletResponse)this.servletResponse);
            } else {
                req.getRequestDispatcher(v.getUri()).include((ServletRequest)req, (ServletResponse)this.servletResponse);
            }
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendStream(StreamView streamView) throws IOException {
        String contentType;
        InputStream inputStream = streamView.getInputStream();
        if (null != streamView.getName()) {
            this.servletResponse.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(streamView.getName(), "utf-8"));
        }
        if (null == (contentType = streamView.getContentType()) || contentType.length() < 1) {
            contentType = "application/octet-stream";
        }
        if (streamView.getSize() > -1L) {
            this.servletResponse.setHeader("Content-Length", streamView.getSize() + "");
        }
        this.sendStream(inputStream, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStream(InputStream inputStream, String contentType) throws IOException {
        this.servletResponse.setContentType(contentType);
        ServletOutputStream os = null;
        try {
            os = this.servletResponse.getOutputStream();
            int n = 0;
            byte[] b = new byte[IOUtil.BUFFER_SIZE];
            while ((n = inputStream.read(b)) != -1) {
                os.write(b, 0, n);
            }
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
            IOUtil.closeQuietly(inputStream);
        }
    }

    public void sendStream(InputStream inputStream) throws IOException {
        this.sendStream(inputStream, "application/octet-stream");
    }
}

