/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend;

import com.nlf.App;
import com.nlf.bytecode.ByteCodeReader;
import com.nlf.core.impl.DefaultProxy;
import com.nlf.extend.HotSwapClassLoader;
import com.nlf.log.Logger;
import com.nlf.resource.klass.ClassResource;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HotSwapProxy
extends DefaultProxy {
    protected static final Map<String, Class<?>> CLASS_POOL = new HashMap();
    protected static final Map<String, Long> CLASS_LAST_MODIFIED = new HashMap<String, Long>();

    public <T> T newInstance(String interfaceOrClassName) {
        long time;
        String implClass = App.getImplement((String[])new String[]{interfaceOrClassName});
        if (null == implClass) {
            return null;
        }
        ClassResource res = (ClassResource)App.CLASS.get(implClass);
        try {
            time = res.lastModified();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Long cachedTime = CLASS_LAST_MODIFIED.get(implClass);
        Class<?> klass = CLASS_POOL.get(implClass);
        if (null == cachedTime) {
            CLASS_LAST_MODIFIED.put(implClass, time);
        } else if (time != cachedTime) {
            CLASS_LAST_MODIFIED.put(implClass, time);
            Logger.getLog().debug(App.getProperty((String)"nlf.extend.proxy.hotswap", (Object[])new Object[]{implClass}));
            HotSwapClassLoader classLoader = new HotSwapClassLoader(Thread.currentThread().getContextClassLoader());
            try {
                klass = classLoader.load(implClass, new ByteCodeReader().readClass(res));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (null == klass) {
                klass = Class.forName(implClass);
            }
            CLASS_POOL.put(implClass, klass);
            return (T)klass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

