/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http.impl;

import com.nlf.App;
import com.nlf.extend.rpc.server.impl.http.AbstractHttpRpcResponse;
import com.nlf.extend.web.view.StreamView;
import com.nlf.util.IOUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

public class DefaultHttpRpcResponse
extends AbstractHttpRpcResponse {
    public void send(Object o) throws IOException {
        if (null == o) {
            return;
        }
        if (o instanceof StreamView) {
            this.sendStream((StreamView)o);
        } else {
            super.send(o);
        }
    }

    public void sendString(String s) throws IOException {
        this.sendString(s, "text/plain");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendString(String s, String contentType) throws IOException {
        if (App.getPropertyBoolean((String)"nlf.rpc.server.http.cors.enable", (boolean)true)) {
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Credentials", App.getPropertyBoolean((String)"nlf.rpc.server.http.cors.allow_credentials", (boolean)true) + "");
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Origin", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_origin", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Methods", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_methods", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Allow-Headers", App.getPropertyString((String)"nlf.rpc.server.http.cors.allow_headers", (String)"*"));
            this.exchange.getResponseHeaders().add("Access-Control-Max-Age", App.getPropertyInt((String)"nlf.rpc.server.http.cors.max_age", (int)18000) + "");
        }
        this.exchange.getResponseHeaders().add("Content-Type", contentType + ";charset=" + "utf-8");
        byte[] bytes = s.getBytes("utf-8");
        int len = bytes.length;
        this.exchange.getResponseHeaders().add("Content-Length", len + "");
        this.exchange.sendResponseHeaders(200, len);
        OutputStream os = null;
        try {
            os = this.exchange.getResponseBody();
            os.write(bytes);
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
        }
    }

    public void sendStream(StreamView streamView) throws IOException {
        String contentType;
        InputStream inputStream = streamView.getInputStream();
        if (null != streamView.getName()) {
            this.exchange.getResponseHeaders().add("Content-Disposition", "attachment;filename=" + URLEncoder.encode(streamView.getName(), "utf-8"));
        }
        if (null == (contentType = streamView.getContentType()) || contentType.length() < 1) {
            contentType = "application/octet-stream";
        }
        if (streamView.getSize() > -1L) {
            this.exchange.getResponseHeaders().add("Content-Length", streamView.getSize() + "");
        }
        this.sendStream(inputStream, contentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendStream(InputStream inputStream, String contentType) throws IOException {
        this.exchange.getResponseHeaders().add("Content-Type", contentType);
        OutputStream os = null;
        try {
            os = this.exchange.getResponseBody();
            int n = 0;
            byte[] b = new byte[IOUtil.BUFFER_SIZE];
            while ((n = inputStream.read(b)) != -1) {
                os.write(b, 0, n);
            }
            os.flush();
        }
        finally {
            IOUtil.closeQuietly((Closeable)os);
            IOUtil.closeQuietly((Closeable)inputStream);
        }
    }

    public void sendStream(InputStream inputStream) throws IOException {
        this.sendStream(inputStream, "application/octet-stream");
    }
}

