/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http.impl;

import com.nlf.App;
import com.nlf.extend.rpc.server.impl.http.AbstractHttpRpcResourceHandler;
import com.nlf.util.ContentTypes;
import com.nlf.util.IOUtil;
import com.nlf.util.StringUtil;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;

public class DefaultHttpRpcResourceHandler
extends AbstractHttpRpcResourceHandler {
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String ENCODING_GZIP = "gzip";
    public static final String ETAG = "Etag";
    public static final String IF_NONE_MATCH = "If-None-Match";
    public static final String LAST_MODIFIED = "Last-Modified";
    public static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    public static final String MSG_304 = "304 Not Modified";
    public static final String MSG_403 = "403 Forbidden";
    public static final String MSG_404 = "404 Not Found";
    public static final String HTML_ERROR = "<!DOCTYPE html><html><head><meta charset=\"%s\" /><title>%s</title></head><body><h3>%s</h3></body></html>";
    public static final String DEFAULT_ROOT = "";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_HOME_PAGE = "index.html";
    public static final String DEFAULT_GZIP_FILE_EXT = ".htm,.html,.css,.js,.bmp,.gif,.jpg,.jpeg,.png,.xml,.svg,.ttf";
    public static final boolean DEFAULT_DIR_ALLOWED = true;
    public static final boolean DEFAULT_GZIP_ENABLE = true;
    public static final int DEFAULT_GZIP_MIN_SIZE = 10240;
    protected static final int BUFFER_SIZE = App.getPropertyInt((String)"nlf.rpc.server.http.resource.buffer_size", (int)IOUtil.BUFFER_SIZE);
    protected static final String ROOT = App.getPropertyString((String)"nlf.rpc.server.http.resource.root", (String)"");
    protected static final String CHARSET = App.getPropertyString((String)"nlf.rpc.server.http.resource.charset", (String)"UTF-8");
    protected static final String HOME_PAGE = App.getPropertyString((String)"nlf.rpc.server.http.resource.home_page", (String)"index.html");
    protected static final boolean DIR_ALLOWED = App.getPropertyBoolean((String)"nlf.rpc.server.http.resource.dir_allowed", (boolean)true);
    protected static final boolean GZIP_ENABLE = App.getPropertyBoolean((String)"nlf.rpc.server.http.resource.gzip.enable", (boolean)true);
    protected static final int GZIP_MIN_SIZE = App.getPropertyInt((String)"nlf.rpc.server.http.resource.gzip.min_size", (int)10240);
    protected static final String GZIP_FILE_EXT = App.getPropertyString((String)"nlf.rpc.server.http.resource.gzip.file_ext", (String)".htm,.html,.css,.js,.bmp,.gif,.jpg,.jpeg,.png,.xml,.svg,.ttf");
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);

    public void handle(HttpExchange exchange) throws IOException {
        String path = exchange.getRequestURI().getRawPath();
        while (path.startsWith("/")) {
            path = path.substring(1);
        }
        File file = ROOT.length() > 0 ? new File(ROOT, path) : new File(path);
        file = new File(file.getAbsolutePath());
        OutputStream os = exchange.getResponseBody();
        if (!file.exists()) {
            this.responseError(exchange, 404, os);
        } else if (!file.canRead()) {
            this.responseError(exchange, 403, os);
        } else if (file.isDirectory()) {
            if (DIR_ALLOWED) {
                this.responseDirectory(exchange, file, os);
            } else {
                File homePageFile = new File(file, HOME_PAGE);
                if (!homePageFile.exists() || !homePageFile.canRead()) {
                    this.responseError(exchange, 403, os);
                } else {
                    this.responseFile(exchange, homePageFile, os);
                }
            }
        } else {
            this.responseFile(exchange, file, os);
        }
        IOUtil.closeQuietly((Closeable)os);
    }

    protected void responseDirectory(HttpExchange exchange, File directory, OutputStream os) throws IOException {
        String path = exchange.getRequestURI().getRawPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        StringBuilder s = new StringBuilder().append("<!DOCTYPE html><html><head><meta charset=\"").append(CHARSET).append("\" /><title>").append(path).append("</title></head><body><h3>").append(path).append("</h3><ul><li><a href=\"../\">..</a></li>");
        File[] files = directory.listFiles();
        if (null != files) {
            for (File file : files) {
                if (!file.canRead()) continue;
                String fileName = file.getName();
                s.append("<li><a href=\"").append(path).append(fileName).append("\">").append(fileName).append("</a></li>");
            }
        }
        s.append("</ul></body></html>");
        this.responseOk(exchange, s.toString(), os);
    }

    protected void responseOk(HttpExchange exchange, String html, OutputStream os) throws IOException {
        this.responseHtml(exchange, 200, html, os);
    }

    protected void responseError(HttpExchange exchange, int code, OutputStream os) throws IOException {
        String msg = DEFAULT_ROOT;
        switch (code) {
            case 403: {
                msg = String.format(HTML_ERROR, CHARSET, MSG_403, MSG_403);
                break;
            }
            case 404: {
                msg = String.format(HTML_ERROR, CHARSET, MSG_404, MSG_404);
                break;
            }
        }
        this.responseHtml(exchange, code, msg, os);
    }

    protected void responseHtml(HttpExchange exchange, int code, String html, OutputStream os) throws IOException {
        byte[] content = html.getBytes(CHARSET);
        exchange.getResponseHeaders().add(CONTENT_TYPE, String.format("text/html; charset=%s", CHARSET));
        exchange.sendResponseHeaders(code, content.length);
        os.write(content);
    }

    protected void responseFile(HttpExchange exchange, File file, OutputStream os) throws IOException {
        long length = file.length();
        long lastModified = file.lastModified();
        String etag = String.format("%s-%s", Long.toHexString(lastModified), Long.toHexString(length));
        String ifNoneMatch = exchange.getRequestHeaders().getFirst(IF_NONE_MATCH);
        String modifiedSince = DATE_FORMAT.format(new Date(lastModified));
        String ifModifiedSince = exchange.getRequestHeaders().getFirst(IF_MODIFIED_SINCE);
        if (null != ifNoneMatch) {
            if (etag.equals(ifNoneMatch)) {
                this.responseHtml(exchange, 304, MSG_304, os);
                return;
            }
        } else if (null != ifModifiedSince && modifiedSince.equals(ifModifiedSince)) {
            this.responseHtml(exchange, 304, MSG_304, os);
            return;
        }
        String fileName = file.getName();
        String ext = DEFAULT_ROOT;
        if (fileName.contains(".")) {
            ext = fileName.substring(fileName.lastIndexOf("."));
        }
        exchange.getResponseHeaders().add(CONTENT_TYPE, ContentTypes.getContentType((String)ext));
        exchange.getResponseHeaders().add(LAST_MODIFIED, modifiedSince);
        exchange.getResponseHeaders().add(ETAG, etag);
        List acceptEncodings = new ArrayList();
        String acceptEncoding = exchange.getRequestHeaders().getFirst(ACCEPT_ENCODING);
        if (null != acceptEncoding) {
            acceptEncodings = StringUtil.list((String)acceptEncoding, (String)",");
        }
        List exts = StringUtil.list((String)GZIP_FILE_EXT, (String)",");
        if (acceptEncodings.contains(ENCODING_GZIP) && GZIP_ENABLE && length >= (long)GZIP_MIN_SIZE && exts.contains(ext)) {
            this.responseGzip(exchange, file, os);
        } else {
            this.responseStream(exchange, file, os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void responseStream(HttpExchange exchange, File file, OutputStream os) throws IOException {
        exchange.sendResponseHeaders(200, file.length());
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] buffer = new byte[BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                os.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(in);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)in);
    }

    protected void responseGzip(HttpExchange exchange, File file, OutputStream os) throws IOException {
        byte[] data = this.gzip(file);
        exchange.getResponseHeaders().add(CONTENT_ENCODING, ENCODING_GZIP);
        exchange.sendResponseHeaders(200, data.length);
        os.write(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] gzip(File file) throws IOException {
        FileInputStream in = null;
        GZIPOutputStream gs = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            in = new FileInputStream(file);
            gs = new GZIPOutputStream(os);
            byte[] buffer = new byte[BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                gs.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(gs);
            IOUtil.closeQuietly((Closeable)in);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)gs);
        IOUtil.closeQuietly((Closeable)in);
        return os.toByteArray();
    }
}

