/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http;

import com.nlf.core.AbstractRequest;
import com.nlf.extend.rpc.server.impl.http.HttpRpcServer;
import com.nlf.extend.rpc.server.impl.http.IHttpRpcRequest;
import com.nlf.util.IOUtil;
import com.nlf.util.InputStreamCache;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractHttpRpcRequest
extends AbstractRequest
implements IHttpRpcRequest {
    protected HttpExchange exchange;
    protected InputStreamCache inputStreamCache;

    public HttpExchange getHttpExchange() {
        return this.exchange;
    }

    public void setHttpExchange(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public String getPath() {
        String path = this.exchange.getRequestURI().getPath();
        if (path.startsWith(HttpRpcServer.contextPath + "/")) {
            path = path.substring(HttpRpcServer.contextPath.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public InputStream getInputStream() throws IOException {
        if (null == this.inputStreamCache) {
            this.inputStreamCache = new InputStreamCache(this.exchange.getRequestBody());
        }
        return this.inputStreamCache.getInputStream();
    }

    public String getBodyString() {
        String body = "";
        try {
            body = new String(IOUtil.toBytes((InputStream)this.getInputStream()), "utf-8");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return body;
    }
}

