/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.http;

import com.nlf.App;
import com.nlf.core.AbstractResponse;
import com.nlf.extend.rpc.server.impl.http.IHttpRpcResponse;
import com.nlf.util.IOUtil;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.zip.GZIPOutputStream;

public abstract class AbstractHttpRpcResponse
extends AbstractResponse
implements IHttpRpcResponse {
    protected static final int BUFFER_SIZE = App.getPropertyInt((String)"nlf.rpc.server.http.resource.buffer_size", (int)IOUtil.BUFFER_SIZE);
    protected static final String ROOT = App.getPropertyString((String)"nlf.rpc.server.http.resource.root", (String)"");
    protected static final String CHARSET = App.getPropertyString((String)"nlf.rpc.server.http.resource.charset", (String)"UTF-8");
    protected static final String HOME_PAGE = App.getPropertyString((String)"nlf.rpc.server.http.resource.home_page", (String)"index.html");
    protected static final boolean DIR_ALLOWED = App.getPropertyBoolean((String)"nlf.rpc.server.http.resource.dir_allowed", (boolean)true);
    protected static final boolean GZIP_ENABLE = App.getPropertyBoolean((String)"nlf.rpc.server.http.resource.gzip.enable", (boolean)true);
    protected static final int GZIP_MIN_SIZE = App.getPropertyInt((String)"nlf.rpc.server.http.resource.gzip.min_size", (int)10240);
    protected static final String GZIP_FILE_EXT = App.getPropertyString((String)"nlf.rpc.server.http.resource.gzip.file_ext", (String)".htm,.html,.css,.js,.bmp,.gif,.jpg,.jpeg,.png,.xml,.svg,.ttf");
    protected static final String MSG_304 = App.getPropertyString((String)"nlf.rpc.server.msg.304", (String)"304 Not Modified");
    protected static final String MSG_403 = App.getPropertyString((String)"nlf.rpc.server.msg.403", (String)"403 Forbidden");
    protected static final String MSG_404 = App.getPropertyString((String)"nlf.rpc.server.msg.404", (String)"404 Not Found");
    protected static final String MSG_HTML = App.getPropertyString((String)"nlf.rpc.server.msg.html", (String)"<!DOCTYPE html><html><head><meta charset=\"%s\" /><title>%s</title></head><body><h3>%s</h3></body></html>");
    protected static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
    protected HttpExchange exchange;

    public HttpExchange getHttpExchange() {
        return this.exchange;
    }

    public void setHttpExchange(HttpExchange exchange) {
        this.exchange = exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] gzip(File file) throws IOException {
        FileInputStream in = null;
        GZIPOutputStream gs = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            in = new FileInputStream(file);
            gs = new GZIPOutputStream(os);
            byte[] buffer = new byte[BUFFER_SIZE];
            int n = 0;
            while (-1 != (n = ((InputStream)in).read(buffer))) {
                gs.write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(gs);
            IOUtil.closeQuietly((Closeable)in);
            throw throwable;
        }
        IOUtil.closeQuietly((Closeable)gs);
        IOUtil.closeQuietly((Closeable)in);
        return os.toByteArray();
    }
}

