/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.socket;

import com.nlf.App;
import com.nlf.View;
import com.nlf.extend.rpc.server.impl.socket.ISocketRpcFilter;
import com.nlf.extend.rpc.server.impl.socket.ISocketRpcFilterChain;
import com.nlf.log.Logger;
import com.nlf.serialize.json.JSON;
import com.nlf.util.IOUtil;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketRpcHandler
implements Runnable {
    private Socket socket;

    public SocketRpcHandler(Socket socket) {
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.socket.getInputStream();
            out = this.socket.getOutputStream();
            ISocketRpcFilterChain filterChain = (ISocketRpcFilterChain)App.getProxy().newInstance(ISocketRpcFilterChain.class.getName());
            ISocketRpcFilter filter = (ISocketRpcFilter)App.getProxy().newInstance(ISocketRpcFilter.class.getName());
            filter.doFilter(this.socket, filterChain);
        }
        catch (Exception e) {
            try {
                Logger.getLog().error("500 Internal Server Error", (Throwable)e);
                try {
                    DataOutputStream os = new DataOutputStream(out);
                    os.writeUTF("nrpc");
                    os.writeShort(8);
                    os.writeUTF(JSON.fromObject((Object)View.json((Object)"500 Internal Server Error").setSuccess(false)));
                    os.writeShort(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly((Closeable)in);
                IOUtil.closeQuietly(out);
                IOUtil.closeQuietly((Socket)this.socket);
                throw throwable;
            }
            IOUtil.closeQuietly((Closeable)in);
            IOUtil.closeQuietly((Closeable)out);
            IOUtil.closeQuietly((Socket)this.socket);
        }
        IOUtil.closeQuietly((Closeable)in);
        IOUtil.closeQuietly((Closeable)out);
        IOUtil.closeQuietly((Socket)this.socket);
    }
}

