/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.socket;

import com.nlf.App;
import com.nlf.extend.rpc.server.AbstractRpcServer;
import com.nlf.extend.rpc.server.impl.socket.ISocketRpcFilter;
import com.nlf.extend.rpc.server.impl.socket.SocketRpcHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;

public class SocketRpcServer
extends AbstractRpcServer
implements Runnable {
    private ExecutorService executor;
    private ServerSocket serverSocket;

    public void bind(int port) throws IOException {
        this.serverSocket = new ServerSocket(port);
        this.serverSocket.setSoTimeout(0);
        this.executor = this.getExecutor();
        this.executor.execute(this);
    }

    public void run() {
        ISocketRpcFilter filter = (ISocketRpcFilter)App.getProxy().newInstance(ISocketRpcFilter.class.getName());
        filter.init();
        while (Thread.currentThread().isAlive()) {
            try {
                Socket socket = this.serverSocket.accept();
                this.executor.execute(new SocketRpcHandler(socket));
            }
            catch (IOException iOException) {}
        }
    }

    public boolean support(String type) {
        return "SOCKET".equalsIgnoreCase(type);
    }
}

