/*
 * Decompiled with CFR 0.152.
 */
package com.nlf.extend.rpc.server.impl.socket.impl;

import com.nlf.App;
import com.nlf.core.Client;
import com.nlf.core.ISession;
import com.nlf.core.UploadFile;
import com.nlf.extend.rpc.server.impl.socket.AbstractSocketRpcRequest;
import com.nlf.extend.rpc.server.impl.socket.SocketRpcServer;
import com.nlf.extend.rpc.socket.ISocketRpcFileUploader;
import com.nlf.util.StringUtil;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSocketRpcRequest
extends AbstractSocketRpcRequest {
    protected String body = "";
    protected ISocketRpcFileUploader uploader = (ISocketRpcFileUploader)App.getProxy().newInstance(ISocketRpcFileUploader.class.getName());

    protected String getIp() {
        String r = this.socket.getInetAddress().getHostAddress();
        if (null != r && "0:0:0:0:0:0:0:1".equals(r)) {
            r = "127.0.0.1";
        }
        return null == r ? "" : r;
    }

    protected String buildPath(String path) {
        if (path.startsWith(SocketRpcServer.contextPath + "/")) {
            path = path.substring(SocketRpcServer.contextPath.length());
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    @Override
    public void init() {
        try {
            DataInputStream in = new DataInputStream(this.getInputStream());
            String magic = in.readUTF();
            if (!"nrpc".equals(magic)) {
                throw new RuntimeException("magic error");
            }
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            String name = null;
            String fileName = null;
            long fileSize = 0L;
            short type = in.readShort();
            while (type != 0) {
                switch (type) {
                    case 1: {
                        this.locale = in.readUTF();
                        break;
                    }
                    case 2: {
                        this.path = this.buildPath(in.readUTF());
                        break;
                    }
                    case 3: {
                        name = in.readUTF();
                        break;
                    }
                    case 4: {
                        if (null == name) break;
                        String value = in.readUTF();
                        if (params.containsKey(name)) {
                            ArrayList<String> vs;
                            Object v = params.get(name);
                            if (v instanceof String) {
                                vs = new ArrayList<String>();
                                vs.add((String)v);
                                vs.add(value);
                                params.put(name, vs);
                                break;
                            }
                            vs = (ArrayList<String>)v;
                            vs.add(value);
                            params.put(name, vs);
                            break;
                        }
                        params.put(name, value);
                        break;
                    }
                    case 5: {
                        fileName = in.readUTF();
                        break;
                    }
                    case 6: {
                        fileSize = in.readLong();
                        break;
                    }
                    case 7: {
                        this.uploader.parseFile(fileName, fileSize, in);
                        break;
                    }
                    case 9: {
                        this.body = in.readUTF();
                        break;
                    }
                }
                type = in.readShort();
            }
            for (String key : params.keySet()) {
                Object v = params.get(key);
                String value = null;
                String[] values = null;
                if (v instanceof String) {
                    value = (String)v;
                } else {
                    List vs = (List)v;
                    values = new String[vs.size()];
                    vs.toArray(values);
                }
                if (null == value) {
                    value = "";
                }
                if (null == values) {
                    values = new String[]{};
                }
                this.param.set(key, (Object)value);
                if (values.length <= 1) continue;
                this.param.set(key, (Object)values);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.initPaging();
    }

    protected void initPaging() {
        int pageNumber = this.param.getInt("pageNumber", this.pageNumber);
        int pageSize = this.param.getInt("pageSize", this.pageSize);
        this.setPageNumber(pageNumber);
        this.setPageSize(pageSize);
    }

    public Client getClient() {
        if (null == this.client) {
            this.client = new Client();
            this.client.setIp(this.getIp());
            if (null == this.locale) {
                this.client.setLocale(Locale.getDefault());
            } else {
                String language = StringUtil.left((String)this.locale, (String)"-");
                String country = StringUtil.right((String)this.locale, (String)"-");
                if (2 != country.length()) {
                    this.client.setLocale(new Locale(language));
                } else {
                    this.client.setLocale(new Locale(language, country));
                }
            }
        }
        return this.client;
    }

    public ISession getSession(boolean autoCreate) {
        return null;
    }

    public List<UploadFile> getFiles() {
        return this.uploader.getFiles();
    }

    public String getBodyString() {
        return null == this.body ? "" : this.body;
    }
}

