/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.jd;

import com.tyme.AbstractTyme;
import com.tyme.culture.Week;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTime;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/tyme/jd/JulianDay;", "Lcom/tyme/AbstractTyme;", "day", "", "<init>", "(D)V", "getDay", "getName", "", "next", "n", "", "getSolarDay", "Lcom/tyme/solar/SolarDay;", "getSolarTime", "Lcom/tyme/solar/SolarTime;", "getWeek", "Lcom/tyme/culture/Week;", "subtract", "target", "Companion", "tyme4kt"})
public final class JulianDay
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double day;
    public static final double J2000 = 2451545.0;

    public JulianDay(double day) {
        this.day = day;
    }

    public final double getDay() {
        return this.day;
    }

    @Override
    @NotNull
    public String getName() {
        return String.valueOf(this.day);
    }

    @Override
    @NotNull
    public JulianDay next(int n) {
        return new JulianDay(this.day + (double)n);
    }

    @NotNull
    public final SolarDay getSolarDay() {
        return this.getSolarTime().getSolarDay();
    }

    @NotNull
    public final SolarTime getSolarTime() {
        int d = (int)(this.day + 0.5);
        double f = this.day + 0.5 - (double)d;
        if (d >= 2299161) {
            int c = (int)(((double)d - 1867216.25) / 36524.25);
            d += 1 + c - (int)((double)c * 0.25);
        }
        int y = (int)(((double)(d += 1524) - 122.1) / 365.25);
        int m = (int)((double)(d -= (int)(365.25 * (double)y)) / 30.601);
        d -= (int)(30.601 * (double)m);
        if (m > 13) {
            m -= 12;
        } else {
            --y;
        }
        --m;
        y -= 4715;
        int hour = (int)(f *= 24.0);
        f -= (double)hour;
        int minute = (int)(f *= 60.0);
        f -= (double)minute;
        int second = (int)Math.rint(f *= 60.0);
        return second < 60 ? new SolarTime(y, m, d, hour, minute, second) : new SolarTime(y, m, d, hour, minute, second - 60).next(60);
    }

    @NotNull
    public final Week getWeek() {
        return new Week((int)(this.day + 0.5) + 7000001);
    }

    public final double subtract(@NotNull JulianDay target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.day - target.getDay();
    }

    @JvmStatic
    @NotNull
    public static final JulianDay fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
        return Companion.fromYmdHms(year, month, day, hour, minute, second);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/tyme/jd/JulianDay$Companion;", "", "<init>", "()V", "J2000", "", "fromYmdHms", "Lcom/tyme/jd/JulianDay;", "year", "", "month", "day", "hour", "minute", "second", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JulianDay fromYmdHms(int year, int month, int day, int hour, int minute, int second) {
            boolean g;
            int y = year;
            int m = month;
            double d = (double)day + (((double)second * 1.0 / (double)60 + (double)minute) / (double)60 + (double)hour) / (double)24;
            int n = 0;
            boolean bl = g = y * 372 + m * 31 + (int)d >= 588829;
            if (m <= 2) {
                m += 12;
                --y;
            }
            if (g) {
                n = (int)((double)y * 0.01);
                n = 2 - n + (int)((double)n * 0.25);
            }
            return new JulianDay((double)((int)(365.25 * (double)(y + 4716)) + (int)(30.6001 * (double)(m + 1))) + d + (double)n - 1524.5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

