/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.rabbyung;

import com.tyme.AbstractTyme;
import com.tyme.culture.Zodiac;
import com.tyme.rabbyung.RabByungDay;
import com.tyme.rabbyung.RabByungElement;
import com.tyme.rabbyung.RabByungYear;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 )2\u00020\u0001:\u0001)B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bB)\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u000eJ\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0005J\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u0016\u001a\u00020\u0010J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H\u0016J\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0005H\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 J\u0006\u0010!\u001a\u00020\u0005J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050 J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050 J\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050 J\u0013\u0010%\u001a\u00020\u00102\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0002J\b\u0010(\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/tyme/rabbyung/RabByungMonth;", "Lcom/tyme/AbstractTyme;", "year", "Lcom/tyme/rabbyung/RabByungYear;", "month", "", "<init>", "(Lcom/tyme/rabbyung/RabByungYear;I)V", "(II)V", "rabByungIndex", "element", "Lcom/tyme/rabbyung/RabByungElement;", "zodiac", "Lcom/tyme/culture/Zodiac;", "(ILcom/tyme/rabbyung/RabByungElement;Lcom/tyme/culture/Zodiac;I)V", "leap", "", "indexInYear", "getYear", "getMonth", "getMonthWithLeap", "getIndexInYear", "isLeap", "getName", "", "getAlias", "toString", "next", "n", "getFirstDay", "Lcom/tyme/rabbyung/RabByungDay;", "getDays", "", "getDayCount", "getSpecialDays", "getLeapDays", "getMissDays", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nRabByungMonth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RabByungMonth.kt\ncom/tyme/rabbyung/RabByungMonth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,304:1\n1#2:305\n37#3,2:306\n*S KotlinDebug\n*F\n+ 1 RabByungMonth.kt\ncom/tyme/rabbyung/RabByungMonth\n*L\n269#1:306,2\n*E\n"})
public final class RabByungMonth
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private RabByungYear year;
    private int month;
    private boolean leap;
    private int indexInYear;
    @NotNull
    private static final String[] NAMES;
    @NotNull
    private static final String[] ALIAS;
    @NotNull
    private static final Map<Integer, int[]> DAYS;

    public RabByungMonth(@NotNull RabByungYear year, int month) {
        int index;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)year, (String)"year");
                if (!((-12 <= month ? month < 13 : false) && month != 0)) {
                    boolean $i$a$-require-RabByungMonth$52 = false;
                    String $i$a$-require-RabByungMonth$52 = "illegal rab-byung month: " + month;
                    throw new IllegalArgumentException($i$a$-require-RabByungMonth$52.toString());
                }
                int y = year.getYear();
                if (!(1950 <= y ? y < 2051 : false)) {
                    boolean $i$a$-require-RabByungMonth$62 = false;
                    String $i$a$-require-RabByungMonth$62 = "rab-byung year " + y + " must between 1950 and 2050";
                    throw new IllegalArgumentException($i$a$-require-RabByungMonth$62.toString());
                }
                int m = 0;
                m = month;
                boolean leap = false;
                if (month < 0) {
                    m = -m;
                    leap = true;
                }
                if (!(y != 1950 || m >= 12)) {
                    boolean $i$a$-require-RabByungMonth$72 = false;
                    String $i$a$-require-RabByungMonth$72 = "month " + month + " must be 12 in rab-byung year " + y;
                    throw new IllegalArgumentException($i$a$-require-RabByungMonth$72.toString());
                }
                int leapMonth = year.getLeapMonth();
                if (!(!leap || m == leapMonth)) {
                    boolean bl = false;
                    String string = "illegal leap month " + m + " in rab-byung year " + y;
                    throw new IllegalArgumentException(string.toString());
                }
                this.year = year;
                this.month = m;
                this.leap = leap;
                index = m - 1;
                if (leap) break block8;
                boolean bl = 1 <= leapMonth ? leapMonth < m : false;
                if (!bl) break block9;
            }
            ++index;
        }
        this.indexInYear = index;
    }

    public RabByungMonth(int year, int month) {
        this(RabByungYear.Companion.fromYear(year), month);
    }

    public RabByungMonth(int rabByungIndex, @NotNull RabByungElement element, @NotNull Zodiac zodiac, int month) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)zodiac, (String)"zodiac");
        this(RabByungYear.Companion.fromElementZodiac(rabByungIndex, element, zodiac), month);
    }

    public final int getYear() {
        return this.year.getYear();
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getMonthWithLeap() {
        return this.leap ? -this.month : this.month;
    }

    public final int getIndexInYear() {
        return this.indexInYear;
    }

    public final boolean isLeap() {
        return this.leap;
    }

    @Override
    @NotNull
    public String getName() {
        return (this.leap ? "\u95f0" : "") + NAMES[this.month - 1];
    }

    @NotNull
    public final String getAlias() {
        return (this.leap ? "\u95f0" : "") + ALIAS[this.month - 1];
    }

    @Override
    @NotNull
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    @NotNull
    public RabByungMonth next(int n) {
        int m;
        if (n == 0) {
            return Companion.fromYm(this.getYear(), this.getMonthWithLeap());
        }
        RabByungYear y = this.year;
        if (n > 0) {
            int monthCount = y.getMonthCount();
            while (m > monthCount) {
                m -= monthCount;
                y = y.next(1);
                monthCount = y.getMonthCount();
            }
        } else {
            for (m = this.indexInYear + 1 + n; m <= 0; m += y.getMonthCount()) {
                y = y.next(-1);
            }
        }
        boolean leap = false;
        int leapMonth = y.getLeapMonth();
        if (leapMonth > 0) {
            if (m == leapMonth + 1) {
                leap = true;
            }
            if (m > leapMonth) {
                --m;
            }
        }
        return Companion.fromYm(y.getYear(), leap ? -m : m);
    }

    @NotNull
    public final RabByungDay getFirstDay() {
        return new RabByungDay(this, 1);
    }

    @NotNull
    public final List<RabByungDay> getDays() {
        List l = new ArrayList();
        List<Integer> missDays = this.getMissDays();
        List<Integer> leapDays = this.getLeapDays();
        for (int i = 1; i < 31; ++i) {
            if (missDays.contains(i)) continue;
            l.add(new RabByungDay(this, i));
            if (!leapDays.contains(i)) continue;
            l.add(new RabByungDay(this, -i));
        }
        return l;
    }

    public final int getDayCount() {
        return 30 + this.getLeapDays().size() - this.getMissDays().size();
    }

    @NotNull
    public final List<Integer> getSpecialDays() {
        List l = new ArrayList();
        int[] nArray = DAYS.get(this.getYear() * 13 + this.getIndexInYear());
        if (nArray == null) {
            return l;
        }
        for (int d : nArray) {
            l.add(d);
        }
        return l;
    }

    @NotNull
    public final List<Integer> getLeapDays() {
        List l = new ArrayList();
        List<Integer> days = this.getSpecialDays();
        Iterator<Integer> iterator = days.iterator();
        while (iterator.hasNext()) {
            int d = ((Number)iterator.next()).intValue();
            if (d <= 0) continue;
            l.add(d);
        }
        return l;
    }

    @NotNull
    public final List<Integer> getMissDays() {
        List l = new ArrayList();
        List<Integer> days = this.getSpecialDays();
        Iterator<Integer> iterator = days.iterator();
        while (iterator.hasNext()) {
            int d = ((Number)iterator.next()).intValue();
            if (d >= 0) continue;
            l.add(-d);
        }
        return l;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof RabByungMonth && Intrinsics.areEqual((Object)this.toString(), (Object)((RabByungMonth)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final RabByungMonth fromYm(int year, int month) {
        return Companion.fromYm(year, month);
    }

    @JvmStatic
    @NotNull
    public static final RabByungMonth fromElementZodiac(int rabByungIndex, @NotNull RabByungElement element, @NotNull Zodiac zodiac, int month) {
        return Companion.fromElementZodiac(rabByungIndex, element, zodiac, month);
    }

    static {
        String[] stringArray = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        NAMES = stringArray;
        stringArray = new String[]{"\u795e\u53d8\u6708", "\u82e6\u884c\u6708", "\u5177\u9999\u6708", "\u8428\u560e\u6708", "\u4f5c\u51c0\u6708", "\u660e\u51c0\u6708", "\u5177\u9189\u6708", "\u5177\u8d24\u6708", "\u5929\u964d\u6708", "\u6301\u4f17\u6708", "\u5e84\u4e25\u6708", "\u6ee1\u610f\u6708"};
        ALIAS = stringArray;
        DAYS = new HashMap();
        int y = 1950;
        int m = 11;
        CharSequence charSequence = "2c>,182[>1:2TA4ZI=n1E2Bk1J2Ff3Mk503Oc62g=,172^>1:2XA1>2UE2Bo1I2Fj3Lo62Fb3Mf5,03N^72b=1:2]A1>2ZF1B2VI2Em1K2Fe,2Lh1R3Na603P\\:172Y>1;2UB2=m2Dq1J2Eh,2Kl1Q3Me603Pa:172^>1;2YA2=p1C2UI,2Dk2Jp3QEc3Mi603Pf:3L[72b?1:2]A1<2UB2XH,2Cn1I2Ei1L2Ie1Q3Na703Q\\:2`@1;2XA,4\\H;m1B2TI2Em1L2Ij1Q3Nf603Q`903QW:,2[@1;2TB2XI1E4TMAh2Io3RFe3Mj603Pc803Q[;,2^?1;2WA2>q1E2Bm1I2Fi1M2Hc3Of70,3P^82a>1:2[A1>2WE1B2TI2Fm1L2Hf3Ni6,03Oa703PZ:3`A62V>4]F;q1B4YJ>l2Eq1L2Gi3Ml5,03Nd603Q_9172[>1;2XB2>p1E2VK2Fl,1K2Fc3Mh603Pc9172`>1;2\\B1>2UD2=j2En,1J2Fg3Mm62Ib3Pj;3M_703R[:2`B1=2YB2=n,1C2TI2Fk1L2Ig1P3Nd703Q_:152X<2[A,2<q1B2WI2Ep1L2Il1Q3Ni703Qc9152[:2^@,1;2WB2>o1E2Bk1I2Fh1M2Ib3Pf803R^9,2a?1;2ZA1>2UE2Bp1I2Fl1M2If3Oi80,3Pa803QY:2^A1>2ZE1B4WJ>j2Fp1M2Hi1N2H`,3Od703Q]:162Y>1;2VB2?o1E4VM@h2Gl1M,2Hd3Ng603Qa9172^>1;2ZB1?2UE2@l2Fo1L,2Gg3Mk62H`3Pf:172c?3QY;2_B1>2YD2?o1E,2TK2Fj1M2Ie1P3Mb703R^;172X=2\\C1>,2TD2WJ2Fn1L2Ij1P3Ng703Rb:162[<2_B1=,2VC2>m1E4TMAh2Io3QFe3Nl82Ja3Qf:152_;0,3RU<2ZB1>2TE2Bn1I2Fj1M2Je3Pk:2K^3Ra:,03RY;2]A1>2XE1B2TI2Fo1M2Ii1P2Ka3Qd8,03R]:3bB62W>4]F:q1B2?n1F4VNAh2Il1O2Jd,3Pg803Q`:162\\=1;2XB1?2TF2Bl2Ho1N,2Ig3Nk703Qd9162`>1;2]B1?2XE2Ao1G2TM,2Hj1M2Id1P3M_603R\\;172W>2\\E1@2TE,2?i2Gm1M2Ih1P3Md603Ra;172[=28q1?2WD,2?m2Fq1M2Il1P3Mi72I^3Re:162_<172W=,2ZC2?q1E2Bk1I2Fh1M2Jd1Q3M^52b;16,2Y<2]B1>2VE2Bp1I2Fm1M2Jh1Q2Lb3Re:15,2\\;3aC62U>2[E1B4WJ>k1F4TNBg2Jl1P2Le3Qh9,03R`:172Z=1:2VB2?q1F2Bk2Ip1P2Jg,1P2J_3Qc:162^=1;2[B1?2WF2Bo1H2Bg2Ij,1O2Jc3Qg:3L\\62c>3QY;3aC72V?2[F1A2TG2Bj,2Hm1N2Jg1P3Mb603R_;182Z>1:2T@2WF2Am,2Gp1M2Ik1P3Mg603Rc;172^>192W?2ZE,2@p1F2Bj2Io3QEe1M2Jb1Q3M]72b=182Z>,2]D1?2VE2Bn1I2Fk1M2Jg1Q3Ma62e<172]=,172U>2YE1B2UI2Fp1N2Jk1Q3Me503M\\6,2`<172Y>3_F:2TB2?n1F2Cj2Jo3QDc2Lh1R,3L_52c;172]=1:2XB1?2UF2Cn1I2Eg2Kk1P,2Lb3Rf;162a=1:2]B1?2ZF1B2TH2Dj2Jm,1O2Kf1Q3M`603Q\\;182Y?2;q1A2WH2Cm,2Hq1O2Ji1P3Me603Qa;182]>1:2WA2[G2Ap,1G2Bi2Im1P3Mi72I_3Qf;3N\\72Eh1:2Z?29o,1@2UF2Bm1I2Fh1M2Je1Q3N`72f?3PY92]>19,2U?2YF2Bq1I2Fm1M2Jj1Q3Nd603O]72`=,182X?4]F:o1B4WI=k1F4UNCi2Jn3REc3Mh503N`6,2c<182\\>1:2VA2?q1F2Cm1J2Fg2Lk1R3Mc5,2f<172`=1:2[A1?2XF2Cq1I2Ek2Kn1R,2Lf1R3N_62d>3PZ:3aC72W?2;p1B2WI2Dn1J,2De2Ki1Q3Mc603Q_:182\\?1;2VB2<m2Cq1I,2Dh2Jl1P3Mg603Qd;182`?1;2ZA2<p1B,2UH2Cl1I2Ef3Mm82Jc1Q3N_703QY:2]@1;2UA,2XG2Bp1I2Fk1M2Jh1Q3Nc703Q]92`?1:,2X@4\\G:n1B2VI2Fp1M2Jl1R3Ng603P`82d>,192[?1;2UA2>o1F2Ck1J2Gg3Mk603Oc70,3OZ82_>1:2YA1?2VF2Cp1J2Fj1M2Gc3Nf5,03O^72b>1:2^B1?4[G;n1C2VJ2Fn1L2Gf,3Mi503Nb603Q]:172Y?1<2UB2>m2Eq1K2Fi,2Kl1R3Mf603Qa:182^?1;2YB2>q1D2VJ,2Dl1J2Fe3Mj603Qg;3N]72c@3QX;2]A1=2VB,2YI2Co1J2Fi1M2Je1Q3Nb703R]:2aA1<2XA,2<n1C2UI2Fn1M2Jj1Q3Nf703Q`903RX:,2[@1<2TB4YJ>l1E4UNBi1J2Ge3Mk703Pc803Q[9,2^?1;2XB2>q1E2Cn1J2Gj1M2Ic3Of70,3P^82b?1;2\\A1>2XF1C2UJ2Fm1M2Hf3Ni6,03Oa703Q[:3aB72W>1<2TC2?m2Fq1L2Gi3Ml5,03Ne703Q_:172\\>1<2XB2?q1E2WL2Fl,1L2Gd3Ni603Qd:172a?1;2\\B1>2VD2>k,2Eo1K2Gh1M2Ic1Q3N`703R\\;3aC62U=2YC2>o,1D2TJ2Fl1M2Jh1Q3Ne703R`:162Y<2\\B,1=2TC4XJ=j2Fp1M2Jm3QFc3Ni803Qc:152\\;2_A,1<2WB2>o1E2Bl1J2Gh1N2Jc3Qg903R^:,2b@1;2[B1>2VE2Cq1J2Gl1N2Jf3Pj80,3Qa803RZ;2_B1>4[F:o1C4XK?k2Fp1M2Ii1O2Ia,3Pd703R^:172Y>1<2VC2?p1F2Ai2Hl1M,2Hd3Oh703Qb:172^>1<2[C1?2UE2Al2Go,1L2Hg3Nl82Ia3Qg;3M]72e@3RZ;3`C72T>2YD2@o1E,2TK2Gk1M2Jf1Q3Nb703R^;172Y=2\\D1>,2TD4XK>i2Fo1M2Jj1Q3Ng703Rb;172\\<2`C1=,2WC2?n1F4VNBi1J2Gf1N2Kb3Rf:162_;15,2V<2ZB1?2TE2Bn1J2Gk1N2Kf1Q2L^3Rb:,152Z;2^B1>2YE1B2UJ2Go1N2Ji1P2Kb3Qd9,03R];172X>1;2TC2@n1G2Bi2Im1O2Jd,3Ph803Ra:172\\>1;2YC1@2UF2Bl2Hp1N,2Ig3Ol82J`3Qe:172a>1;4^C7q1?2XF2Ao1G2UN,2Hj1N2Jd1Q3N`703R];182X>2]F1@2TF,2@j2Gn1M2Jq1Q3Ne703Ra;172\\>192T?,2WE2@m1F4TMAf2Im3QEc3Nj82J`3Rf;172_=182W>,2ZD2?q1F2Bl1I2Gj1N2Ke1R3M_62b<17,2Z=2]C1?2WE2Bq1I2Gn1N2Ki1Q3Mb52e;16,2]<172V>4[F:o1B4XK?l1G4UOCh2Jl1Q2Le3Rh:,152`;172Z>1;2WB2@q1G2Cl2Ip1P2K_";
        Regex regex = new Regex(",");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] years = thisCollection$iv.toArray(new String[0]);
        int n2 = years.length;
        for (int i = 0; i < n2; ++i) {
            String tys;
            String ys = tys = years[i];
            while (((CharSequence)ys).length() > 0) {
                int len = ys.charAt(0) - 48;
                int[] data = new int[len];
                for (int i2 = 0; i2 < len; ++i2) {
                    data[i2] = ys.charAt(i2 + 1) - 53 - 30;
                }
                DAYS.put(y * 13 + m, data);
                ++m;
                Intrinsics.checkNotNullExpressionValue((Object)ys.substring(len + 1), (String)"substring(...)");
            }
            ++y;
            m = 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0007J(\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u000eH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u000b\u0010\bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lcom/tyme/rabbyung/RabByungMonth$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "ALIAS", "getALIAS", "DAYS", "", "", "", "getDAYS", "()Ljava/util/Map;", "fromYm", "Lcom/tyme/rabbyung/RabByungMonth;", "year", "month", "fromElementZodiac", "rabByungIndex", "element", "Lcom/tyme/rabbyung/RabByungElement;", "zodiac", "Lcom/tyme/culture/Zodiac;", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @NotNull
        public final String[] getALIAS() {
            return ALIAS;
        }

        @NotNull
        protected final Map<Integer, int[]> getDAYS() {
            return DAYS;
        }

        @JvmStatic
        @NotNull
        public final RabByungMonth fromYm(int year, int month) {
            return new RabByungMonth(year, month);
        }

        @JvmStatic
        @NotNull
        public final RabByungMonth fromElementZodiac(int rabByungIndex, @NotNull RabByungElement element, @NotNull Zodiac zodiac, int month) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)zodiac, (String)"zodiac");
            return new RabByungMonth(rabByungIndex, element, zodiac, month);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

