/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Taboo;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.culture.star.twelve.TwelveStar;
import com.tyme.eightchar.EightChar;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarHour;
import com.tyme.lunar.LunarMonth;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.sixtycycle.SixtyCycleMonth;
import com.tyme.sixtycycle.SixtyCycleYear;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\n\u001a\u00020\tJ\u0006\u0010\u000b\u001a\u00020\tJ\u0006\u0010\f\u001a\u00020\tJ\u0006\u0010\r\u001a\u00020\tJ\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aJ\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/tyme/sixtycycle/SixtyCycleHour;", "Lcom/tyme/AbstractTyme;", "solarTime", "Lcom/tyme/solar/SolarTime;", "<init>", "(Lcom/tyme/solar/SolarTime;)V", "day", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "hour", "Lcom/tyme/sixtycycle/SixtyCycle;", "getYear", "getMonth", "getDay", "getSixtyCycle", "getSixtyCycleDay", "getSolarTime", "getName", "", "toString", "getIndexInDay", "", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getTwelveStar", "Lcom/tyme/culture/star/twelve/TwelveStar;", "getRecommends", "", "Lcom/tyme/culture/Taboo;", "getAvoids", "next", "n", "getEightChar", "Lcom/tyme/eightchar/EightChar;", "Companion", "tyme4kt"})
public final class SixtyCycleHour
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private SolarTime solarTime;
    @NotNull
    private SixtyCycleDay day;
    @NotNull
    private SixtyCycle hour;

    public SixtyCycleHour(@NotNull SolarTime solarTime) {
        SolarTerm term;
        int index;
        Intrinsics.checkNotNullParameter((Object)solarTime, (String)"solarTime");
        this.solarTime = solarTime;
        int solarYear = this.solarTime.getYear();
        SolarTime springSolarTime = new SolarTerm(solarYear, 3).getJulianDay().getSolarTime();
        LunarHour lunarHour = this.solarTime.getLunarHour();
        LunarDay lunarDay = lunarHour.getLunarDay();
        LunarYear lunarYear = lunarDay.getLunarMonth().getLunarYear();
        if (lunarYear.getYear() == solarYear) {
            if (this.solarTime.isBefore(springSolarTime)) {
                lunarYear = lunarYear.next(-1);
            }
        } else if (lunarYear.getYear() < solarYear && !this.solarTime.isBefore(springSolarTime)) {
            lunarYear = lunarYear.next(1);
        }
        if ((index = (term = this.solarTime.getTerm()).getIndex() - 3) < 0 && term.getJulianDay().getSolarTime().isAfter(new SolarTerm(solarYear, 3).getJulianDay().getSolarTime())) {
            index += 24;
        }
        SixtyCycle d = lunarDay.getSixtyCycle();
        this.day = new SixtyCycleDay(this.solarTime.getSolarDay(), new SixtyCycleMonth(new SixtyCycleYear(lunarYear.getYear()), LunarMonth.Companion.fromYm(solarYear, 1).getSixtyCycle().next((int)Math.floor((double)index * 0.5))), this.solarTime.getHour() < 23 ? d : d.next(1));
        this.hour = lunarHour.getSixtyCycle();
    }

    @NotNull
    public final SixtyCycle getYear() {
        return this.day.getYear();
    }

    @NotNull
    public final SixtyCycle getMonth() {
        return this.day.getMonth();
    }

    @NotNull
    public final SixtyCycle getDay() {
        return this.day.getSixtyCycle();
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return this.hour;
    }

    @NotNull
    public final SixtyCycleDay getSixtyCycleDay() {
        return this.day;
    }

    @NotNull
    public final SolarTime getSolarTime() {
        return this.solarTime;
    }

    @Override
    @NotNull
    public String getName() {
        return this.hour.getName() + "\u65f6";
    }

    @Override
    @NotNull
    public String toString() {
        return this.day + this.getName();
    }

    public final int getIndexInDay() {
        int h = this.solarTime.getHour();
        return h == 23 ? 0 : (h + 1) / 2;
    }

    @NotNull
    public final NineStar getNineStar() {
        SolarDay solar = this.solarTime.getSolarDay();
        SolarTerm dongZhi = new SolarTerm(solar.getYear(), 0);
        int earthBranchIndex = this.getIndexInDay() % 12;
        int[] nArray = new int[]{8, 5, 2};
        int index = nArray[this.getDay().getEarthBranch().getIndex() % 3];
        index = !solar.isBefore(dongZhi.getJulianDay().getSolarDay()) && solar.isBefore(dongZhi.next(12).getJulianDay().getSolarDay()) ? 8 + earthBranchIndex - index : (index -= earthBranchIndex);
        return new NineStar(index);
    }

    @NotNull
    public final TwelveStar getTwelveStar() {
        return new TwelveStar(this.hour.getEarthBranch().getIndex() + (8 - this.getDay().getEarthBranch().getIndex() % 6) * 2);
    }

    @NotNull
    public final List<Taboo> getRecommends() {
        return Taboo.Companion.getHourRecommends(this.getDay(), this.hour);
    }

    @NotNull
    public final List<Taboo> getAvoids() {
        return Taboo.Companion.getHourAvoids(this.getDay(), this.hour);
    }

    @Override
    @NotNull
    public SixtyCycleHour next(int n) {
        return new SixtyCycleHour(this.solarTime.next(n));
    }

    @NotNull
    public final EightChar getEightChar() {
        return new EightChar(this.getYear(), this.getMonth(), this.getDay(), this.hour);
    }

    @JvmStatic
    @NotNull
    public static final SixtyCycleHour fromSolarTime(@NotNull SolarTime solarTime) {
        return Companion.fromSolarTime(solarTime);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleHour$Companion;", "", "<init>", "()V", "fromSolarTime", "Lcom/tyme/sixtycycle/SixtyCycleHour;", "solarTime", "Lcom/tyme/solar/SolarTime;", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SixtyCycleHour fromSolarTime(@NotNull SolarTime solarTime) {
            Intrinsics.checkNotNullParameter((Object)solarTime, (String)"solarTime");
            return new SixtyCycleHour(solarTime);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

