/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.sixtycycle;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.Twenty;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.sixtycycle.SixtyCycleMonth;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\nH\u0016J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleYear;", "Lcom/tyme/AbstractTyme;", "year", "", "<init>", "(I)V", "getYear", "getSixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "getName", "", "getTwenty", "Lcom/tyme/culture/Twenty;", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getJupiterDirection", "Lcom/tyme/culture/Direction;", "next", "n", "getFirstMonth", "Lcom/tyme/sixtycycle/SixtyCycleMonth;", "getMonths", "", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSixtyCycleYear.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SixtyCycleYear.kt\ncom/tyme/sixtycycle/SixtyCycleYear\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1#2:121\n*E\n"})
public final class SixtyCycleYear
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int year;

    public SixtyCycleYear(int year) {
        this.year = year;
        int n = this.year;
        if (!(-1 <= n ? n < 10000 : false)) {
            boolean bl = false;
            String string = "illegal sixty cycle year: " + this.year;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final int getYear() {
        return this.year;
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return new SixtyCycle(this.year - 4);
    }

    @Override
    @NotNull
    public String getName() {
        return this.getSixtyCycle().getName() + "\u5e74";
    }

    @NotNull
    public final Twenty getTwenty() {
        return new Twenty((int)Math.floor((double)(this.year - 1864) / 20.0));
    }

    @NotNull
    public final NineStar getNineStar() {
        return new NineStar(63 + this.getTwenty().getSixty().getIndex() * 3 - this.getSixtyCycle().getIndex());
    }

    @NotNull
    public final Direction getJupiterDirection() {
        int[] nArray = new int[]{0, 7, 7, 2, 3, 3, 8, 1, 1, 6, 0, 0};
        return new Direction(nArray[this.getSixtyCycle().getEarthBranch().getIndex()]);
    }

    @Override
    @NotNull
    public SixtyCycleYear next(int n) {
        return new SixtyCycleYear(this.year + n);
    }

    @NotNull
    public final SixtyCycleMonth getFirstMonth() {
        return new SixtyCycleMonth(this, new SixtyCycle(new HeavenStem((this.getSixtyCycle().getHeavenStem().getIndex() + 1) * 2).getName() + "\u5bc5"));
    }

    @NotNull
    public final List<SixtyCycleMonth> getMonths() {
        List l = new ArrayList();
        SixtyCycleMonth m = this.getFirstMonth();
        l.add(m);
        for (int i = 1; i < 12; ++i) {
            l.add(m.next(i));
        }
        return l;
    }

    @JvmStatic
    @NotNull
    public static final SixtyCycleYear fromYear(int year) {
        return Companion.fromYear(year);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/tyme/sixtycycle/SixtyCycleYear$Companion;", "", "<init>", "()V", "fromYear", "Lcom/tyme/sixtycycle/SixtyCycleYear;", "year", "", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SixtyCycleYear fromYear(int year) {
            return new SixtyCycleYear(year);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

