/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Constellation;
import com.tyme.culture.Week;
import com.tyme.culture.dog.Dog;
import com.tyme.culture.dog.DogDay;
import com.tyme.culture.nine.Nine;
import com.tyme.culture.nine.NineDay;
import com.tyme.culture.phenology.Phenology;
import com.tyme.culture.phenology.PhenologyDay;
import com.tyme.culture.plumrain.PlumRain;
import com.tyme.culture.plumrain.PlumRainDay;
import com.tyme.enums.HideHeavenStemType;
import com.tyme.festival.SolarFestival;
import com.tyme.holiday.LegalHoliday;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarMonth;
import com.tyme.rabbyung.RabByungDay;
import com.tyme.sixtycycle.HideHeavenStem;
import com.tyme.sixtycycle.HideHeavenStemDay;
import com.tyme.sixtycycle.SixtyCycleDay;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarTerm;
import com.tyme.solar.SolarTermDay;
import com.tyme.solar.SolarWeek;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 ?2\u00020\u0001:\u0001?B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\n\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u0004\u0018\u00010&J\b\u0010'\u001a\u0004\u0018\u00010(J\b\u0010)\u001a\u0004\u0018\u00010*J\u0006\u0010+\u001a\u00020,J\u0006\u0010-\u001a\u00020\u0003J\u000e\u0010.\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202J\u0006\u00103\u001a\u000204J\u0006\u00105\u001a\u000206J\b\u00107\u001a\u0004\u0018\u000108J\b\u00109\u001a\u0004\u0018\u00010:J\u0013\u0010;\u001a\u00020\u00172\b\u0010<\u001a\u0004\u0018\u00010=H\u0096\u0002J\b\u0010>\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/tyme/solar/SolarDay;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "day", "<init>", "(III)V", "Lcom/tyme/solar/SolarMonth;", "getSolarMonth", "getYear", "getMonth", "getDay", "getWeek", "Lcom/tyme/culture/Week;", "getConstellation", "Lcom/tyme/culture/Constellation;", "getName", "", "toString", "next", "n", "isBefore", "", "target", "isAfter", "getTerm", "Lcom/tyme/solar/SolarTerm;", "getTermDay", "Lcom/tyme/solar/SolarTermDay;", "getSolarWeek", "Lcom/tyme/solar/SolarWeek;", "start", "getPhenology", "Lcom/tyme/culture/phenology/Phenology;", "getPhenologyDay", "Lcom/tyme/culture/phenology/PhenologyDay;", "getDogDay", "Lcom/tyme/culture/dog/DogDay;", "getNineDay", "Lcom/tyme/culture/nine/NineDay;", "getPlumRainDay", "Lcom/tyme/culture/plumrain/PlumRainDay;", "getHideHeavenStemDay", "Lcom/tyme/sixtycycle/HideHeavenStemDay;", "getIndexInYear", "subtract", "getJulianDay", "Lcom/tyme/jd/JulianDay;", "getLunarDay", "Lcom/tyme/lunar/LunarDay;", "getSixtyCycleDay", "Lcom/tyme/sixtycycle/SixtyCycleDay;", "getRabByungDay", "Lcom/tyme/rabbyung/RabByungDay;", "getLegalHoliday", "Lcom/tyme/holiday/LegalHoliday;", "getFestival", "Lcom/tyme/festival/SolarFestival;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarDay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarDay.kt\ncom/tyme/solar/SolarDay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,436:1\n1#2:437\n*E\n"})
public final class SolarDay
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int day;
    @NotNull
    private SolarMonth month;
    @NotNull
    private static final String[] NAMES;

    public SolarDay(int year, int month, int day) {
        this.day = day;
        if (!(this.day >= 1)) {
            boolean bl = false;
            String string = "illegal solar day: " + year + "-" + month + "-" + this.day;
            throw new IllegalArgumentException(string.toString());
        }
        SolarMonth m = new SolarMonth(year, month);
        if (1582 == year && 10 == month) {
            int n = this.day;
            if (!(!(5 <= n ? n < 15 : false) && this.day <= 31)) {
                boolean $i$a$-require-SolarDay$42 = false;
                String $i$a$-require-SolarDay$42 = "illegal solar day: " + year + "-" + month + "-" + this.day;
                throw new IllegalArgumentException($i$a$-require-SolarDay$42.toString());
            }
        } else if (!(this.day <= m.getDayCount())) {
            boolean bl = false;
            String string = "illegal solar day: " + year + "-" + month + "-" + this.day;
            throw new IllegalArgumentException(string.toString());
        }
        this.month = m;
    }

    @NotNull
    public final SolarMonth getSolarMonth() {
        return this.month;
    }

    public final int getYear() {
        return this.month.getYear();
    }

    public final int getMonth() {
        return this.month.getMonth();
    }

    public final int getDay() {
        return this.day;
    }

    @NotNull
    public final Week getWeek() {
        return this.getJulianDay().getWeek();
    }

    @NotNull
    public final Constellation getConstellation() {
        int y = this.getMonth() * 100 + this.day;
        return new Constellation(y > 1221 || y < 120 ? 9 : (y < 219 ? 10 : (y < 321 ? 11 : (y < 420 ? 0 : (y < 521 ? 1 : (y < 622 ? 2 : (y < 723 ? 3 : (y < 823 ? 4 : (y < 923 ? 5 : (y < 1024 ? 6 : (y < 1123 ? 7 : 8)))))))))));
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.day - 1];
    }

    @Override
    @NotNull
    public String toString() {
        return this.month + this.getName();
    }

    @Override
    @NotNull
    public SolarDay next(int n) {
        return this.getJulianDay().next(n).getSolarDay();
    }

    public final boolean isBefore(@NotNull SolarDay target) {
        int bMonth;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int aYear = this.getYear();
        int bYear = target.getYear();
        if (aYear != bYear) {
            return aYear < bYear;
        }
        int aMonth = this.getMonth();
        return aMonth != (bMonth = target.getMonth()) ? aMonth < bMonth : this.day < target.getDay();
    }

    public final boolean isAfter(@NotNull SolarDay target) {
        int bMonth;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int aYear = this.getYear();
        int bYear = target.getYear();
        if (aYear != bYear) {
            return aYear > bYear;
        }
        int aMonth = this.getMonth();
        return aMonth != (bMonth = target.getMonth()) ? aMonth > bMonth : this.day > target.getDay();
    }

    @NotNull
    public final SolarTerm getTerm() {
        return this.getTermDay().getSolarTerm();
    }

    @NotNull
    public final SolarTermDay getTermDay() {
        int y = this.getYear();
        int i = this.getMonth() * 2;
        if (i == 24) {
            ++y;
            i = 0;
        }
        SolarTerm term = new SolarTerm(y, i);
        SolarDay day = term.getJulianDay().getSolarDay();
        while (this.isBefore(day)) {
            term = term.next(-1);
            day = term.getJulianDay().getSolarDay();
        }
        return new SolarTermDay(term, this.subtract(day));
    }

    @NotNull
    public final SolarWeek getSolarWeek(int start) {
        int y = this.getYear();
        int m = this.getMonth();
        return new SolarWeek(y, m, (int)Math.ceil((double)(this.day + new SolarDay(y, m, 1).getWeek().next(-start).getIndex()) / 7.0) - 1, start);
    }

    @NotNull
    public final Phenology getPhenology() {
        return this.getPhenologyDay().getPhenology();
    }

    @NotNull
    public final PhenologyDay getPhenologyDay() {
        SolarTermDay d = this.getTermDay();
        int dayIndex = d.getDayIndex();
        int index = dayIndex / 5;
        if (index > 2) {
            index = 2;
        }
        SolarTerm term = d.getSolarTerm();
        return new PhenologyDay(new Phenology(term.getYear(), term.getIndex() * 3 + index), dayIndex - index * 5);
    }

    @Nullable
    public final DogDay getDogDay() {
        SolarTerm xiaZhi = new SolarTerm(this.getYear(), 12);
        SolarDay start = xiaZhi.getJulianDay().getSolarDay();
        int days = this.subtract(start = start.next(start.getLunarDay().getSixtyCycle().getHeavenStem().stepsTo(6) + 20));
        if (days < 0) {
            return null;
        }
        if (days < 10) {
            return new DogDay(new Dog(0), days);
        }
        days = this.subtract(start = start.next(10));
        if (days < 10) {
            return new DogDay(new Dog(1), days);
        }
        start = start.next(10);
        days = this.subtract(start);
        if (xiaZhi.next(3).getJulianDay().getSolarDay().isAfter(start)) {
            if (days < 10) {
                return new DogDay(new Dog(1), days + 10);
            }
            start = start.next(10);
            days = this.subtract(start);
        }
        return days >= 10 ? null : new DogDay(new Dog(2), days);
    }

    @Nullable
    public final NineDay getNineDay() {
        int year = this.getYear();
        SolarDay start = new SolarTerm(year + 1, 0).getJulianDay().getSolarDay();
        if (this.isBefore(start)) {
            start = new SolarTerm(year, 0).getJulianDay().getSolarDay();
        }
        SolarDay end = start.next(81);
        if (this.isBefore(start) || !this.isBefore(end)) {
            return null;
        }
        int days = this.subtract(start);
        return new NineDay(new Nine(days / 9), days % 9);
    }

    @Nullable
    public final PlumRainDay getPlumRainDay() {
        SolarTerm grainInEar = new SolarTerm(this.getYear(), 11);
        SolarDay start = grainInEar.getJulianDay().getSolarDay();
        start = start.next(start.getLunarDay().getSixtyCycle().getHeavenStem().stepsTo(2));
        SolarDay end = grainInEar.next(2).getJulianDay().getSolarDay();
        end = end.next(end.getLunarDay().getSixtyCycle().getEarthBranch().stepsTo(7));
        if (this.isBefore(start) || this.isAfter(end)) {
            return null;
        }
        return Intrinsics.areEqual((Object)this, (Object)end) ? new PlumRainDay(new PlumRain(1), 0) : new PlumRainDay(new PlumRain(0), this.subtract(start));
    }

    @NotNull
    public final HideHeavenStemDay getHideHeavenStemDay() {
        int typeIndex;
        int[] nArray = new int[]{3, 5, 7, 9, 10, 30};
        int[] dayCounts = nArray;
        SolarTerm term = this.getTerm();
        if (term.isQi()) {
            term = term.next(-1);
        }
        int dayIndex = this.subtract(term.getJulianDay().getSolarDay());
        int startIndex = (term.getIndex() - 1) * 3;
        String string = "93705542220504xx1513904541632524533533105544806564xx7573304542018584xx95".substring(startIndex, startIndex + 6);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String data = string;
        int days = 0;
        int heavenStemIndex = 0;
        for (typeIndex = 0; typeIndex < 3; ++typeIndex) {
            String d;
            int i = typeIndex * 2;
            Intrinsics.checkNotNullExpressionValue((Object)data.substring(i, i + 1), (String)"substring(...)");
            int count = 0;
            if (!Intrinsics.areEqual((Object)d, (Object)"x")) {
                heavenStemIndex = Integer.parseInt(d, CharsKt.checkRadix((int)10));
                String string2 = data.substring(i + 1, i + 2);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                count = dayCounts[Integer.parseInt(string2, CharsKt.checkRadix((int)10))];
                days += count;
            }
            if (dayIndex > days) continue;
            dayIndex -= days - count;
            break;
        }
        HideHeavenStemType type = switch (typeIndex) {
            case 0 -> HideHeavenStemType.RESIDUAL;
            case 1 -> HideHeavenStemType.MIDDLE;
            default -> HideHeavenStemType.MAIN;
        };
        return new HideHeavenStemDay(new HideHeavenStem(heavenStemIndex, type), dayIndex);
    }

    public final int getIndexInYear() {
        return this.subtract(new SolarDay(this.getYear(), 1, 1));
    }

    public final int subtract(@NotNull SolarDay target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return (int)this.getJulianDay().subtract(target.getJulianDay());
    }

    @NotNull
    public final JulianDay getJulianDay() {
        return JulianDay.Companion.fromYmdHms(this.getYear(), this.getMonth(), this.day, 0, 0, 0);
    }

    @NotNull
    public final LunarDay getLunarDay() {
        int days;
        LunarMonth m = LunarMonth.Companion.fromYm(this.getYear(), this.getMonth());
        for (days = this.subtract(m.getFirstJulianDay().getSolarDay()); days < 0; days += m.getDayCount()) {
            m = m.next(-1);
        }
        return new LunarDay(m.getYear(), m.getMonthWithLeap(), days + 1);
    }

    @NotNull
    public final SixtyCycleDay getSixtyCycleDay() {
        return new SixtyCycleDay(this);
    }

    @NotNull
    public final RabByungDay getRabByungDay() {
        return RabByungDay.Companion.fromSolarDay(this);
    }

    @Nullable
    public final LegalHoliday getLegalHoliday() {
        return LegalHoliday.Companion.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    @Nullable
    public final SolarFestival getFestival() {
        return SolarFestival.Companion.fromYmd(this.getYear(), this.getMonth(), this.day);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarDay && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarDay)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarDay fromYmd(int year, int month, int day) {
        return Companion.fromYmd(year, month, day);
    }

    static {
        String[] stringArray = new String[]{"1\u65e5", "2\u65e5", "3\u65e5", "4\u65e5", "5\u65e5", "6\u65e5", "7\u65e5", "8\u65e5", "9\u65e5", "10\u65e5", "11\u65e5", "12\u65e5", "13\u65e5", "14\u65e5", "15\u65e5", "16\u65e5", "17\u65e5", "18\u65e5", "19\u65e5", "20\u65e5", "21\u65e5", "22\u65e5", "23\u65e5", "24\u65e5", "25\u65e5", "26\u65e5", "27\u65e5", "28\u65e5", "29\u65e5", "30\u65e5", "31\u65e5"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/tyme/solar/SolarDay$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromYmd", "Lcom/tyme/solar/SolarDay;", "year", "", "month", "day", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final SolarDay fromYmd(int year, int month, int day) {
            return new SolarDay(year, month, day);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

