/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarMonth;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/tyme/solar/SolarSeason;", "Lcom/tyme/AbstractTyme;", "year", "", "index", "<init>", "(II)V", "Lcom/tyme/solar/SolarYear;", "getSolarYear", "getYear", "getIndex", "getName", "", "toString", "next", "n", "getMonths", "", "Lcom/tyme/solar/SolarMonth;", "equals", "", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarSeason.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarSeason.kt\ncom/tyme/solar/SolarSeason\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1#2:98\n*E\n"})
public final class SolarSeason
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int index;
    @NotNull
    private SolarYear year;
    @NotNull
    private static final String[] NAMES;

    public SolarSeason(int year, int index) {
        this.index = index;
        int n = this.index;
        if (!(0 <= n ? n < 4 : false)) {
            boolean bl = false;
            String string = "illegal solar season index: " + this.index;
            throw new IllegalArgumentException(string.toString());
        }
        this.year = new SolarYear(year);
    }

    @NotNull
    public final SolarYear getSolarYear() {
        return this.year;
    }

    public final int getYear() {
        return this.year.getYear();
    }

    public final int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.index];
    }

    @Override
    @NotNull
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    @NotNull
    public SolarSeason next(int n) {
        int i = this.index + n;
        return new SolarSeason((this.getYear() * 4 + i) / 4, this.indexOf(i, 4));
    }

    @NotNull
    public final List<SolarMonth> getMonths() {
        List l = new ArrayList(3);
        int y = this.year.getYear();
        for (int i = 1; i < 4; ++i) {
            l.add(new SolarMonth(y, this.index * 3 + i));
        }
        return l;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarSeason && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarSeason)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarSeason fromIndex(int year, int index) {
        return Companion.fromIndex(year, index);
    }

    static {
        String[] stringArray = new String[]{"\u4e00\u5b63\u5ea6", "\u4e8c\u5b63\u5ea6", "\u4e09\u5b63\u5ea6", "\u56db\u5b63\u5ea6"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/tyme/solar/SolarSeason$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromIndex", "Lcom/tyme/solar/SolarSeason;", "year", "", "index", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final SolarSeason fromIndex(int year, int index) {
            return new SolarSeason(year, index);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

