/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.lunar;

import com.tyme.AbstractTyme;
import com.tyme.culture.Direction;
import com.tyme.culture.fetus.FetusMonth;
import com.tyme.culture.ren.MinorRen;
import com.tyme.culture.star.nine.NineStar;
import com.tyme.jd.JulianDay;
import com.tyme.lunar.LunarDay;
import com.tyme.lunar.LunarSeason;
import com.tyme.lunar.LunarWeek;
import com.tyme.lunar.LunarYear;
import com.tyme.sixtycycle.EarthBranch;
import com.tyme.sixtycycle.HeavenStem;
import com.tyme.sixtycycle.SixtyCycle;
import com.tyme.solar.SolarTerm;
import com.tyme.util.ShouXingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016B\u0017\b\u0014\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0014\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\nJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\bJ\u0006\u0010\u0015\u001a\u00020\bJ\u0006\u0010\u0016\u001a\u00020\bJ\u0006\u0010\u0017\u001a\u00020\bJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0011J\u0006\u0010\u001b\u001a\u00020\rJ\u000e\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\bH\u0016J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u001d\u001a\u00020\bJ\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020+J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u0004\u0018\u00010/J\u0006\u00100\u001a\u000201J\u0013\u00102\u001a\u00020\r2\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/tyme/lunar/LunarMonth;", "Lcom/tyme/AbstractTyme;", "cache", "", "", "<init>", "([Ljava/lang/Double;)V", "year", "", "month", "(II)V", "Lcom/tyme/lunar/LunarYear;", "leap", "", "dayCount", "indexInYear", "firstJulianDay", "Lcom/tyme/jd/JulianDay;", "getLunarYear", "getYear", "getMonth", "getMonthWithLeap", "getDayCount", "getIndexInYear", "getSeason", "Lcom/tyme/lunar/LunarSeason;", "getFirstJulianDay", "isLeap", "getWeekCount", "start", "getName", "", "toString", "next", "n", "getDays", "", "Lcom/tyme/lunar/LunarDay;", "getWeeks", "Lcom/tyme/lunar/LunarWeek;", "getSixtyCycle", "Lcom/tyme/sixtycycle/SixtyCycle;", "getNineStar", "Lcom/tyme/culture/star/nine/NineStar;", "getJupiterDirection", "Lcom/tyme/culture/Direction;", "getFetus", "Lcom/tyme/culture/fetus/FetusMonth;", "getMinorRen", "Lcom/tyme/culture/ren/MinorRen;", "equals", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nLunarMonth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LunarMonth.kt\ncom/tyme/lunar/LunarMonth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,359:1\n1#2:360\n*E\n"})
public final class LunarMonth
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LunarYear year;
    private int month;
    private boolean leap;
    private int dayCount;
    private int indexInYear;
    @NotNull
    private JulianDay firstJulianDay;
    @NotNull
    private static final Map<String, Double[]> cache = new HashMap();
    @NotNull
    private static final String[] NAMES;

    protected LunarMonth(@NotNull Double[] cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        int m = (int)cache[1].doubleValue();
        this.year = new LunarYear((int)cache[0].doubleValue());
        this.month = Math.abs(m);
        this.leap = m < 0;
        this.dayCount = (int)cache[2].doubleValue();
        this.indexInYear = (int)cache[3].doubleValue();
        this.firstJulianDay = new JulianDay(cache[4]);
    }

    protected LunarMonth(int year, int month) {
        int index;
        int offset;
        double w;
        int m;
        boolean leap;
        LunarYear currentYear;
        block10: {
            block9: {
                if (!(month != 0 && month <= 12 && month >= -12)) {
                    boolean $i$a$-require-LunarMonth$32 = false;
                    String $i$a$-require-LunarMonth$32 = "illegal lunar month: " + month;
                    throw new IllegalArgumentException($i$a$-require-LunarMonth$32.toString());
                }
                currentYear = new LunarYear(year);
                int y = currentYear.getYear();
                int currentLeapMonth = currentYear.getLeapMonth();
                leap = month < 0;
                m = Math.abs(month);
                if (!(!leap || m == currentLeapMonth)) {
                    boolean bl = false;
                    String string = "illegal leap month " + m + " in lunar year " + year;
                    throw new IllegalArgumentException(string.toString());
                }
                double dongZhiJd = new SolarTerm(year, 0).getCursoryJulianDay();
                w = ShouXingUtil.INSTANCE.calcShuo(dongZhiJd);
                if (w > dongZhiJd) {
                    w -= 29.53;
                }
                offset = 2;
                boolean bl = 9 <= y ? y < 24 : false;
                if (bl) {
                    offset = 1;
                } else if (new LunarYear(year - 1).getLeapMonth() > 10 && y != 239 && y != 240) {
                    offset = 3;
                }
                index = m - 1;
                if (leap) break block9;
                boolean bl2 = 1 <= currentLeapMonth ? currentLeapMonth < m : false;
                if (!bl2) break block10;
            }
            ++index;
        }
        this.indexInYear = index;
        double firstDay = ShouXingUtil.INSTANCE.calcShuo(w += 29.5306 * (double)(offset + index));
        this.firstJulianDay = new JulianDay(2451545.0 + firstDay);
        this.dayCount = (int)(ShouXingUtil.INSTANCE.calcShuo(w + 29.5306) - firstDay);
        this.year = currentYear;
        this.month = m;
        this.leap = leap;
    }

    @NotNull
    public final LunarYear getLunarYear() {
        return this.year;
    }

    public final int getYear() {
        return this.year.getYear();
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getMonthWithLeap() {
        return this.leap ? -this.month : this.month;
    }

    public final int getDayCount() {
        return this.dayCount;
    }

    public final int getIndexInYear() {
        return this.indexInYear;
    }

    @NotNull
    public final LunarSeason getSeason() {
        return new LunarSeason(this.month - 1);
    }

    @NotNull
    public final JulianDay getFirstJulianDay() {
        return this.firstJulianDay;
    }

    public final boolean isLeap() {
        return this.leap;
    }

    public final int getWeekCount(int start) {
        return (int)Math.ceil((double)(this.indexOf(this.firstJulianDay.getWeek().getIndex() - start, 7) + this.getDayCount()) / 7.0);
    }

    @Override
    @NotNull
    public String getName() {
        return (this.leap ? "\u95f0" : "") + NAMES[this.month - 1];
    }

    @Override
    @NotNull
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    @NotNull
    public LunarMonth next(int n) {
        int m;
        if (n == 0) {
            return Companion.fromYm(this.getYear(), this.getMonthWithLeap());
        }
        LunarYear y = this.year;
        if (n > 0) {
            int monthCount = y.getMonthCount();
            while (m > monthCount) {
                m -= monthCount;
                y = y.next(1);
                monthCount = y.getMonthCount();
            }
        } else {
            for (m = this.indexInYear + 1 + n; m <= 0; m += y.getMonthCount()) {
                y = y.next(-1);
            }
        }
        boolean leap = false;
        int leapMonth = y.getLeapMonth();
        if (leapMonth > 0) {
            if (m == leapMonth + 1) {
                leap = true;
            }
            if (m > leapMonth) {
                --m;
            }
        }
        return Companion.fromYm(y.getYear(), leap ? -m : m);
    }

    @NotNull
    public final List<LunarDay> getDays() {
        int size = this.dayCount;
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        List l = new ArrayList(size);
        int i = 1;
        if (i <= size) {
            while (true) {
                l.add(new LunarDay(y, m, i));
                if (i == size) break;
                ++i;
            }
        }
        return l;
    }

    @NotNull
    public final List<LunarWeek> getWeeks(int start) {
        int size = this.getWeekCount(start);
        int y = this.getYear();
        int m = this.getMonthWithLeap();
        List l = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            l.add(new LunarWeek(y, m, i, start));
        }
        return l;
    }

    @NotNull
    public final SixtyCycle getSixtyCycle() {
        return new SixtyCycle(new HeavenStem(this.year.getSixtyCycle().getHeavenStem().getIndex() * 2 + this.month + 1).getName() + new EarthBranch(this.month + 1).getName());
    }

    @NotNull
    public final NineStar getNineStar() {
        int index = this.getSixtyCycle().getEarthBranch().getIndex();
        if (index < 2) {
            index += 3;
        }
        return new NineStar(27 - this.year.getSixtyCycle().getEarthBranch().getIndex() % 3 * 3 - index);
    }

    @NotNull
    public final Direction getJupiterDirection() {
        SixtyCycle sixtyCycle = this.getSixtyCycle();
        int[] nArray = new int[]{7, -1, 1, 3};
        int n = nArray[sixtyCycle.getEarthBranch().next(-2).getIndex() % 4];
        return n != -1 ? new Direction(n) : sixtyCycle.getHeavenStem().getDirection();
    }

    @Nullable
    public final FetusMonth getFetus() {
        return FetusMonth.Companion.fromLunarMonth(this);
    }

    @NotNull
    public final MinorRen getMinorRen() {
        return new MinorRen((this.month - 1) % 6);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof LunarMonth && Intrinsics.areEqual((Object)this.toString(), (Object)((LunarMonth)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final LunarMonth fromYm(int year, int month) {
        return Companion.fromYm(year, month);
    }

    static {
        String[] stringArray = new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"};
        NAMES = stringArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0011\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0007R&\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0007\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/tyme/lunar/LunarMonth$Companion;", "", "<init>", "()V", "cache", "", "", "", "", "getCache", "()Ljava/util/Map;", "NAMES", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "fromYm", "Lcom/tyme/lunar/LunarMonth;", "year", "", "month", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Map<String, Double[]> getCache() {
            return cache;
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @JvmStatic
        @NotNull
        public final LunarMonth fromYm(int year, int month) {
            LunarMonth m = null;
            String key = "" + year + month;
            Double[] c = this.getCache().get(key);
            if (c != null) {
                m = new LunarMonth(c);
            } else {
                m = new LunarMonth(year, month);
                Map<String, Double[]> map = this.getCache();
                Double[] doubleArray = new Double[]{m.getYear(), m.getMonthWithLeap(), m.getDayCount(), m.getIndexInYear(), m.getFirstJulianDay().getDay()};
                map.put(key, doubleArray);
            }
            return m;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

