/*
 * Decompiled with CFR 0.152.
 */
package com.tyme.solar;

import com.tyme.AbstractTyme;
import com.tyme.solar.SolarDay;
import com.tyme.solar.SolarSeason;
import com.tyme.solar.SolarWeek;
import com.tyme.solar.SolarYear;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0003J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001aJ\u0013\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020\u0003H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/tyme/solar/SolarMonth;", "Lcom/tyme/AbstractTyme;", "year", "", "month", "<init>", "(II)V", "Lcom/tyme/solar/SolarYear;", "getYear", "()Lcom/tyme/solar/SolarYear;", "setYear", "(Lcom/tyme/solar/SolarYear;)V", "getSolarYear", "getMonth", "getDayCount", "getIndexInYear", "getSeason", "Lcom/tyme/solar/SolarSeason;", "getWeekCount", "start", "getName", "", "toString", "next", "n", "getWeeks", "", "Lcom/tyme/solar/SolarWeek;", "getDays", "Lcom/tyme/solar/SolarDay;", "equals", "", "other", "", "hashCode", "Companion", "tyme4kt"})
@SourceDebugExtension(value={"SMAP\nSolarMonth.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolarMonth.kt\ncom/tyme/solar/SolarMonth\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,163:1\n1#2:164\n*E\n"})
public final class SolarMonth
extends AbstractTyme {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int month;
    @NotNull
    private SolarYear year;
    @NotNull
    private static final String[] NAMES;
    @NotNull
    private static final int[] DAYS;

    public SolarMonth(int year, int month) {
        this.month = month;
        int n = this.month;
        if (!(1 <= n ? n < 13 : false)) {
            boolean bl = false;
            String string = "illegal solar month: " + this.month;
            throw new IllegalArgumentException(string.toString());
        }
        this.year = new SolarYear(year);
    }

    @NotNull
    protected final SolarYear getYear() {
        return this.year;
    }

    protected final void setYear(@NotNull SolarYear solarYear) {
        Intrinsics.checkNotNullParameter((Object)solarYear, (String)"<set-?>");
        this.year = solarYear;
    }

    @NotNull
    public final SolarYear getSolarYear() {
        return this.year;
    }

    public final int getYear() {
        return this.year.getYear();
    }

    public final int getMonth() {
        return this.month;
    }

    public final int getDayCount() {
        if (1582 == this.getYear() && 10 == this.month) {
            return 21;
        }
        int d = DAYS[this.getIndexInYear()];
        if (2 == this.month && this.year.isLeap()) {
            ++d;
        }
        return d;
    }

    public final int getIndexInYear() {
        return this.month - 1;
    }

    @NotNull
    public final SolarSeason getSeason() {
        return new SolarSeason(this.getYear(), this.getIndexInYear() / 3);
    }

    public final int getWeekCount(int start) {
        return (int)Math.ceil((double)(this.indexOf(new SolarDay(this.getYear(), this.month, 1).getWeek().getIndex() - start, 7) + this.getDayCount()) / 7.0);
    }

    @Override
    @NotNull
    public String getName() {
        return NAMES[this.getIndexInYear()];
    }

    @Override
    @NotNull
    public String toString() {
        return this.year + this.getName();
    }

    @Override
    @NotNull
    public SolarMonth next(int n) {
        int i = this.month - 1 + n;
        return new SolarMonth((this.getYear() * 12 + i) / 12, this.indexOf(i, 12) + 1);
    }

    @NotNull
    public final List<SolarWeek> getWeeks(int start) {
        int size = this.getWeekCount(start);
        int y = this.getYear();
        List l = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            l.add(new SolarWeek(y, this.month, i, start));
        }
        return l;
    }

    @NotNull
    public final List<SolarDay> getDays() {
        int size = this.getDayCount();
        int y = this.getYear();
        List l = new ArrayList(size);
        int i = 1;
        if (i <= size) {
            while (true) {
                l.add(new SolarDay(y, this.month, i));
                if (i == size) break;
                ++i;
            }
        }
        return l;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof SolarMonth && Intrinsics.areEqual((Object)this.toString(), (Object)((SolarMonth)other).toString());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @JvmStatic
    @NotNull
    public static final SolarMonth fromYm(int year, int month) {
        return Companion.fromYm(year, month);
    }

    static {
        Object[] objectArray = new String[]{"1\u6708", "2\u6708", "3\u6708", "4\u6708", "5\u6708", "6\u6708", "7\u6708", "8\u6708", "9\u6708", "10\u6708", "11\u6708", "12\u6708"};
        NAMES = objectArray;
        objectArray = new int[12];
        objectArray[0] = (String)31;
        objectArray[1] = (String)28;
        objectArray[2] = (String)31;
        objectArray[3] = (String)30;
        objectArray[4] = (String)31;
        objectArray[5] = (String)30;
        objectArray[6] = (String)31;
        objectArray[7] = (String)31;
        objectArray[8] = (String)30;
        objectArray[9] = (String)31;
        objectArray[10] = (String)30;
        objectArray[11] = (String)31;
        DAYS = (int[])objectArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0007R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/tyme/solar/SolarMonth$Companion;", "", "<init>", "()V", "NAMES", "", "", "getNAMES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "DAYS", "", "getDAYS", "()[I", "fromYm", "Lcom/tyme/solar/SolarMonth;", "year", "", "month", "tyme4kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getNAMES() {
            return NAMES;
        }

        @NotNull
        public final int[] getDAYS() {
            return DAYS;
        }

        @JvmStatic
        @NotNull
        public final SolarMonth fromYm(int year, int month) {
            return new SolarMonth(year, month);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

